import org.kde.qt.*;

public class CannonField extends QWidget {
	private int ang;
	
	public CannonField(QWidget parent, String name) {
		super(parent, name);
		ang = 45;
		setPalette(new QPalette(new QColor(250, 250, 200)));
	}

	public int angle() {
		return ang;
	}

	public void setAngle(int degrees) {
		if (degrees < 5)
			degrees = 5;
		if (degrees > 70)
			degrees = 70;
		if (ang == degrees)
			return;
		ang = degrees;
		repaint();
		emit("angleChanged", ang);
	}

	public void paintEvent(QPaintEvent e) {
		QPainter p = new QPainter(this);

		p.setBrush(blue());
		p.setPen(NoPen);

		p.translate(0, rect().bottom());
		p.drawPie(new QRect(-35, -35, 70, 70), 0, 90*16);
		p.rotate(-ang);
		p.drawRect(new QRect(33, -4, 15, 8));
	}

	public QSizePolicy sizePolicy() {
		return new QSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding);
	}
}
