/***************************************************************************
                            TreeWalker.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef TREEWALKER_H
#define TREEWALKER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 <code> TreeWalker </code> objects are used to navigate a document
 tree or subtree using the view of the document defined by its
 <code> whatToShow </code> flags and any filters that are defined
 for the <code> TreeWalker </code> . Any function which performs
 navigation using a <code> TreeWalker </code> will automatically
 support any view defined by a <code> TreeWalker </code> .

  Omitting nodes from the logical view of a subtree can result in a
 structure that is substantially different from the same subtree in
 the complete, unfiltered document. Nodes that are siblings in the
 TreeWalker view may be children of different, widely separated
 nodes in the original view. For instance, consider a Filter that
 skips all nodes except for Text nodes and the root node of a
 document. In the logical view that results, all text nodes will be
 siblings and appear as direct children of the root node, no matter
 how deeply nested the structure of the original document.

 
 @short 
 <code> TreeWalker </code> objects are used to navigate a document
 tree or subtree using the view of the document defined by its
 <code> whatToShow </code> flags and any filters that are defined
 for the <code> TreeWalker </code> .
*/
@class DOMNode; 
@class NodeFilter; 

@interface  TreeWalker : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 The root node of the TreeWalker, as specified when it was created.
     
*/
- (DOMNode*) root;

/** 
 This attribute determines which node types are presented via the
 TreeWalker. The available set of constants is defined in the NodeFilter
 interface. Nodes not accepted by whatToShow will be skipped, but their
 children may still be considered. Note that this skip takes precedence
 over the filter, if any.
     
*/
- (unsigned long) whatToShow;

/** 
 The filter used to screen nodes.
     
*/
- (NodeFilter*) filter;

/** 
 The value of this flag determines whether the children of entity
 reference nodes are visible to the TreeWalker. If false, they and their
 descendents will be rejected. Note that this rejection takes precedence
 over whatToShow and the filter, if any.

 To produce a view of the document that has entity references expanded
 and does not expose the entity reference node itself, use the whatToShow
 flags to hide the entity reference node and set expandEntityReferences
 to true when creating the TreeWalker. To produce a view of the document
 that has entity reference nodes but no entity expansion, use the
 whatToShow flags to show the entity reference node and set
 expandEntityReferences to false.
     
*/
- (BOOL) expandEntityReferences;

/** 
 The node at which the TreeWalker is currently positioned.
 Alterations to the DOM tree may cause the current node to no longer be
 accepted by the TreeWalker's associated filter. currentNode may also be
 explicitly set to any node, whether or not it is within the subtree
 specified by the root node or would be accepted by the filter and
 whatToShow flags. Further traversal occurs relative to currentNode even
 if it is not part of the current view, by applying the filters in the
 requested direction; if no traversal is possible, currentNode is not changed.

*/
- (DOMNode*) currentNode;

/** 
 see @ref currentNode
     
*/
- setCurrentNode: (DOMNode*)_currentNode;

/** 
 Moves to and returns the parent node of the current node. If
 there is no parent node, or if the current node is the root
 node from which this TreeWalker was created, retains the
 current position and returns null.

     
*/
- (DOMNode*) parentNode;

/** 
 Moves the <code> TreeWalker </code> to the first child of the
 current node, and returns the new node. If the current node has
 no children, returns <code> null </code> , and retains the
 current node.

     
*/
- (DOMNode*) firstChild;

/** 
 Moves the <code> TreeWalker </code> to the last child of the
 current node, and returns the new node. If the current node has
 no children, returns <code> null </code> , and retains the
 current node.

     
*/
- (DOMNode*) lastChild;

/** 
 Moves the <code> TreeWalker </code> to the previous sibling of
 the current node, and returns the new node. If the current node
 has no previous sibling, returns <code> null </code> , and
 retains the current node.

     
*/
- (DOMNode*) previousSibling;

/** 
 Moves the <code> TreeWalker </code> to the next sibling of the
 current node, and returns the new node. If the current node has
 no next sibling, returns <code> null </code> , and retains the
 current node.

     
*/
- (DOMNode*) nextSibling;

/** 
 Moves the <code> TreeWalker </code> to the previous node in
 document order relative to the current node, and returns the
 new node. If the current node has no previous node, returns
 <code> null </code> , and retains the current node.

     
*/
- (DOMNode*) previousNode;

/** 
 Moves the <code> TreeWalker </code> to the next node in
 document order relative to the current node, and returns the
 new node. If the current node has no next node, returns <code>
 null </code> , and retains the current node.

     
*/
- (DOMNode*) nextNode;
- (BOOL) isNull;
@end

#endif
