/***************************************************************************
                            Text.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef TEXT_H
#define TEXT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/CharacterData.h>

/**

 The <code> Text </code> interface represents the textual content
 (termed <a href="&xml-spec; #-syntax"> character data </a> in XML) of
 an <code> Element </code> or <code> Attr </code> . If there is no
 markup inside an element's content, the text is contained in a
 single object implementing the <code> Text </code> interface that
 is the only child of the element. If there is markup, it is parsed
 into a list of elements and <code> Text </code> nodes that form the
 list of children of the element.

  When a document is first made available via the DOM, there is only
 one <code> Text </code> node for each block of text. Users may
 create adjacent <code> Text </code> nodes that represent the
 contents of a given element without any intervening markup, but
 should be aware that there is no way to represent the separations
 between these nodes in XML or HTML, so they will not (in general)
 persist between DOM editing sessions. The <code> -normalize
 </code> method on <code> Element </code> merges any such adjacent
 <code> Text </code> objects into a single node for each block of
 text; this is recommended before employing operations that depend
 on a particular document structure, such as navigation with <code>
 XPointers. </code>

 
 @short 
 The <code> Text </code> interface represents the textual content
 (termed <a href="&xml-spec;#syntax"> character data </a> in XML) of
 an <code> Element </code> or <code> Attr </code> .
*/
@interface Text : CharacterData 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Breaks this <code> Text </code> node into two Text nodes at the
 specified offset, keeping both in the tree as siblings. This
 node then only contains all the content up to the <code> offset
 </code> point. And a new <code> Text </code> node, which is
 inserted as the next sibling of this node, contains all the
 content at and after the <code> offset </code> point.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
- (Text*) splitText: (unsigned long)offset;
@end

#endif
