/***************************************************************************
                            KURLRequester.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURLREQUESTER_H
#define KURLREQUESTER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QHBox.h>

/**

 This class is a widget showing a lineedit and a button, which invokes a
 filedialog. File name completion is available in the lineedit.

 The defaults for the filedialog are to ask for one existing local file, i.e.
 -[KFileDialog setMode]( -[KFile File]| -[KFile ExistingOnly]| -[KFile LocalOnly])
 The default filter is "*", i.e. show all files, and the start directory is
 the current working directory, or the last directory where a file has been
 selected.

 You can change this behavior by using @ref -setMode or @ref -setFilter.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A widget to request a filename/url from the user.
*/
@class KComboBox; 
@class KFileDialog; 
@class KLineEdit; 
@class KURLCompletion; 
@class QPushButton; 

@interface KURLRequester : QHBox 

/** 
 Constructs a KURLRequester widget.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a KURLRequester widget with the initial URL @p url.
     
*/
- initWithText: (NSString *)url parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)url ;

/** 
 Special constructor, which creates a KURLRequester widget with a custom
 edit-widget. The edit-widget can be either a KComboBox or a KLineEdit
 (or inherited thereof). Note: for geometry management reasons, the
 edit-widget is reparented to have the KURLRequester as parent.

*/
- initWithWidget: (QWidget *)editWidget parent: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)editWidget parent: (QWidget *)parent ;

/** 
 Destructs the KURLRequester.
     
*/
- (void) dealloc;

/** 

*/
- (NSString *) url;

/** 
 Enables/disables showing file:/ in the lineedit, when a local file has
 been selected in the filedialog or was set via @ref -setURL.
 Default is false, not showing file:/

*/
- setShowLocalProtocol: (BOOL)b;

/** 
 Sets the mode of the file dialog.
 Note: you can only select one file with the filedialog,
 so -[KFile Files]doesn't make much sense.

*/
- setMode: (unsigned int)m;

/** 
 Sets the filter for the file dialog.

*/
- setFilter: (NSString *)filter;

/** 

*/
- (BOOL) showLocalProtocol;

/** 

*/
- (KFileDialog*) fileDialog;

/** 

 It is provided so that you can e.g. set an own completion object
 (e.g. @ref KShellCompletion) into it.
     
*/
- (KLineEdit*) lineEdit;

/** 

*/
- (KComboBox*) comboBox;

/** 

*/
- (QPushButton*) button;

/** 

*/
- (KURLCompletion*) completionObject;

/** 
 Sets the url in the lineedit to @p url. Depending on the state of
 @ref -showLocalProtocol, file:/ on local files will be shown or not.
     
*/
- setURL: (NSString *)url;

/** 
 Clears the lineedit/combobox.
     
*/
- clear;
- init;

/** 
 Called when the button is pressed to open the filedialog.
 Also called when @ref -[KStdAccel Open](default is Ctrl-O) is pressed.
     
*/
- slotOpenDialog;
@end

/** Override these methods in subclasses of KURLRequester to customise event handling behaviour */
@protocol KURLRequesterEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
