/***************************************************************************
                            KShred.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHRED_H
#define KSHRED_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 Erase a file in a way that makes recovery impossible -- well, no guarentee
 of that, but at least as difficult as reasonably possible.
 For this, KShred write several times over the
 existing file, using different patterns, before deleting it.

 @author David Faure <faure@kde.org> (integration into KDE and progress signal)
 
 @short 
 Erase a file in a way that makes recovery impossible -- well, no guarentee
 of that, but at least as difficult as reasonably possible.
*/
@interface KShred : QObject 

/** 
 Initialize the class using the name of the file to 'shred'.

*/
- initWithText: (NSString *)fileName;
- (void) dealloc;

/** 
 Writes all 1's over the entire file and flushes the file buffers.

*/
- (BOOL) fill1s;

/** 
 Writes all 0's over the entire file and flushes the file buffers.

*/
- (BOOL) fill0s;

/** 
 Writes the specified byte over the entire file and flushes the file buffers.

*/
- (BOOL) fillbyte: (unsigned int)byte;

/** 
 Writes random bites over the entire file and flushes the file buffers.

*/
- (BOOL) fillrandom;

/** 
 Writes the specified byte array over the entire file and flushes the file buffers.

*/
- (BOOL) fillpattern: (unsigned char*)pattern size: (unsigned int)size;

/** 
 Shreds a file by writing a series of values over it (uses @ref 
 fill0s, then @ref fill1s, then @ref fillrandom, then @ref fillbyte
 with 0101..., then @ref fillbyte with 1010....

*/
- (BOOL) shred;

/** 
 The simplest method to shred a file.
 No need to create an instance of the class.

*/
+ (BOOL) shred: (NSString *)fileName;
@end

/** Override these methods in subclasses of KShred to customise event handling behaviour */
@protocol KShredEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
