/***************************************************************************
                            KScriptManager.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCRIPTMANAGER_H
#define KSCRIPTMANAGER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KScriptClientInterface.h>
#include <qtobjc/QObject.h>

/**

	This class is the base for all script engines.

 @author Ian Reinhart Geiser <geiseri@kde.org>

 @short 
	This class is the base for all script engines.
*/
@interface KScriptManager : KScriptClientInterface 

/** 
	Create a new instance of the script engine.
		
*/
- initWithObject: (QObject *)parent name: (NSString *)name;

/** 
	Destroy the current script engine.
		
*/
- (void) dealloc;

/** 
	Add a new script instance to the script engine.
	This should be the full name and path to the desktop
	file.
		
*/
- (BOOL) addScript: (NSString *)scriptDesktopFile;

/** 
	Remove a script instance from the script engine.

*/
- (BOOL) removeScript: (NSString *)scriptName;

/** 
	Access the names of script instances from the script engine.

*/
- (NSArray *) scripts;

/** 
	Clear all script intstances in memory
		
*/
- clear;

/** 
	This function will allow the main application of any errors
	that have occured during processing of the script.
		
*/
- error: (NSString *)msg;

/** 
	This function will allow the main application of any warnings
	that have occured during the processing of the script.
		
*/
- warning: (NSString *)msg;

/** 
	This function will allow the main application of any normal
	output that has occured during the processing of the script.
		
*/
- output: (NSString *)msg;

/** 
	This function will allow feedback to any progress bars in the main
	application as to how far along the script is.  This is very useful when
	a script is processing files or doing some long operation that is of a
	known duration.
		
*/
- progress: (int)percent;

/** 
	This function will allow feedback on completion of the script.
	It turns the result as a @ref -[KScriptInteface Result], and a return
	value as a @ref QVariant
		
*/
- done: (int)result returned: (QVariant *)returned;

/** 
	Run the selected script
		
*/
- runScript: (NSString *)scriptName context: (QObject *)context arg: (QVariant *)arg;
- runScript: (NSString *)scriptName ;
@end

/** Override these methods in subclasses of KScriptManager to customise event handling behaviour */
@protocol KScriptManagerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
