/***************************************************************************
                            KOpenWithDlg.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KOPENWITHDLG_H
#define KOPENWITHDLG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QDialog.h>

/**

 "Open with" dialog box.
 Used automatically by KRun, and used by libkonq.

 @author David Faure <faure@kde.org>
 
 @short 
 "Open with" dialog box.
*/

@interface KOpenWithDlg : QDialog 

/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
- initWithArray: (NSArray *)urls parent: (QWidget *)parent;
- initWithArray: (NSArray *)urls ;

/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
- initWithArray: (NSArray *)urls text: (NSString *)text value: (NSString *)value parent: (QWidget *)parent;
- initWithArray: (NSArray *)urls text: (NSString *)text value: (NSString *)value ;

/** 
 Create a dialog to select a service for a given service type.
 Note that this dialog doesn't apply to URLs.

*/
- initWithText: (NSString *)serviceType value: (NSString *)value parent: (QWidget *)parent;
- initWithText: (NSString *)serviceType value: (NSString *)value ;

/** 
 Destructor
     
*/
- (void) dealloc;

/** 

*/
- (NSString *) text;

/** 

*/
//- (KService_Ptr*) service;

/** 
 The slot for clearing the edit widget
    
*/
- slotClear;
- slotSelected: (NSString *)_name _exec: (NSString *)_exec;
- slotHighlighted: (NSString *)_name _exec: (NSString *)_exec;
- slotTextChanged;
- slotTerminalToggled: (BOOL)arg1;
- slotDbClick;
- slotOK;

/** 
 Determine service type from URLs
     
*/
- setServiceType: (NSArray *)_urls;

/** 
 Create a dialog that asks for a application to open a given
 URL(s) with.

*/
- init: (NSString *)text value: (NSString *)value;

/** 
 Reimplemented from -[QDialog accept] to save history of the combobox
     
*/
- accept;
@end

/** Override these methods in subclasses of KOpenWithDlg to customise event handling behaviour */
@protocol KOpenWithDlgEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
