/***************************************************************************
                            KFileItem.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEITEM_H
#define KFILEITEM_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 A KFileItem is a generic class to handle a file, local or remote.
 In particular, it makes it easier to handle the result of -[KIO listDir].
 (UDSEntry isn't very friendly to use)
 It includes many file attributes such as mimetype, icon, text, mode, link...
 
 @short 
 A KFileItem is a generic class to handle a file, local or remote.
*/
@class KFileMetaInfo; 
@class KURL; 
@class QPixmap; 


@interface  KFileItem : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates an item representing a file, from a @ref UDSEntry.
 This is the preferred constructor when using -[KIO listDir].

*/
//- initWithUDSEntry: (UDSEntry*)_entry _url: (KURL*)_url _determineMimeTypeOnDemand: (BOOL)_determineMimeTypeOnDemand _urlIsDirectory: (BOOL)_urlIsDirectory;
//- initWithUDSEntry: (UDSEntry*)_entry _url: (KURL*)_url ;

/** 
 Creates an item representing a file, from all the necessary info for it.

*/
- initWithLong: (long)_mode _permissions: (long)_permissions _url: (KURL*)_url _determineMimeTypeOnDemand: (BOOL)_determineMimeTypeOnDemand;
- initWithLong: (long)_mode _permissions: (long)_permissions _url: (KURL*)_url ;

/** 
 Creates an item representing a file, for which the mimetype is already known.

*/
- initWithURL: (KURL*)url mimeType: (NSString *)mimeType mode: (long)mode;

/** 
 Copy constructor. Note that extra-data set via @ref -setExtraData is not
 deeply copied -- just the pointers are copied.
   
*/
- copyWithZone: (NSZone *) zone;

/** 
 Destructs the KFileItem. Extra data set via -setExtraData
 is not deleted.
   
*/
- (void) dealloc;

/** 
 Re-reads information (currently only permissions and mimetype).
 This is called when the _file_ changes.
   
*/
- refresh;

/** 
 Re-reads mimetype information.
 This is called when the mimetype database changes.
   
*/
- refreshMimeType;

/** 
 Returns the url of the file.
   
*/
- (KURL*) url;

/** 
 Sets the item's URL. Do not call unless you know what you are doing!
 (used for example when an item got renamed).
   
*/
- setURL: (KURL*)url;

/** 
 Returns the permissions of the file (stat.st_mode containing only permissions).
   
*/
- (long) permissions;

/** 
 Returns the access permissions for the file as a string.
   
*/
- (NSString *) permissionsString;

/** 
 Returns the file type (stat.st_mode containing only S_IFDIR, S_IFLNK, ...).
   
*/
- (long) mode;

/** 
 Returns the owner of the file.
   
*/
- (NSString *) user;

/** 
 Returns the group of the file.
   
*/
- (NSString *) group;

/** 
 Returns true if this item represents a link in the UNIX sense of
 a link.
   
*/
- (BOOL) isLink;

/** 
 Returns true if this item represents a directory.
   
*/
- (BOOL) isDir;

/** 
 Returns true if this item represents a file (and not a a directory)
   
*/
- (BOOL) isFile;

/** 

*/
- (BOOL) isReadable;

/** 
 Returns the link destination if -isLink == true.
   
*/
- (NSString *) linkDest;

/** 
 Returns the size of the file, if known.
   
*/
- (unsigned long) size;

/** 

*/
- (long) time: (unsigned int)which;

/** 

*/
- (NSString *) timeString: (unsigned int)which;

/** 
 Returns true if the file is a local file.
   
*/
- (BOOL) isLocalFile;

/** 
 Returns the text of the file item.
 It's not exactly the filename since some decoding happens ('%2F'->'/').
   
*/
- (NSString *) text;

/** 

*/
- (NSString *) name: (BOOL)lowerCase;

/** 
 Returns the mimetype of the file item.
   
*/
- (NSString *) mimetype;

/** 
 Returns the mimetype of the file item.
 If determineMimeTypeOnDemand was used, this will determine the mimetype first.
   
*/
//- (KMimeType_Ptr) determineMimeType;

/** 
 Returns the currently known mimetype of the file item.
 This will not try to determine the mimetype if unknown.
   
*/
//- (KMimeType_Ptr) mimeTypePtr;
- (BOOL) isMimeTypeKnown;

/** 
 Returns the descriptive comment for this mime type, or
 the mime type itself if none is present.
   
*/
- (NSString *) mimeComment;

/** 
 Returns the full path name to the icon that represents
 this mime type.
   
*/
- (NSString *) iconName;

/** 
 Returns a pixmap representing the file.

*/
- (QPixmap*) pixmap: (int)_size _state: (int)_state;
- (QPixmap*) pixmap: (int)_size ;

/** 
 Returns the string to be displayed in the statusbar,
 e.g. when the mouse is over this item
   
*/
- (NSString *) getStatusBarInfo;

/** 

*/
- (NSString *) getToolTipText: (int)maxcount;

/** 
 Returns true if files can be dropped over this item.
 Contrary to popular belief, not only dirs will return true :)
 Executables, .desktop files, will do so as well.
   
*/
- (BOOL) acceptsDrops;

/** 
 Let's "KRun" this file !
 (e.g. when file is clicked or double-clicked or return is pressed)
   
*/
- run;

/** 
 Returns the UDS entry. Used by the tree view to access all details
 by position.
   
*/
//- (UDSEntry*) entry;
- (BOOL) isMarked;
- mark;
- unmark;

/** 
 Somewhat like a comparison operator, but more explicit
   
*/
- (BOOL) cmp: (KFileItem*)item;

/** 
 This allows to associate some "extra" data to a KFileItem. As one
 KFileItem can be used by several objects (often views) which all need
 to add some data, you have to use a key to reference your extra data
 within the KFileItem.

 That way a KFileItem can hold and provide access to all those views
 separately.

 I.e. a KFileIconView that associates a KFileIconViewItem (an item suitable
 for use with QIconView) does

 <pre>
 -[kfileItem setExtraData]( this, iconViewItem );
 </pre>

 and can later access the iconViewItem by doing

 <pre>
 KFileIconViewItem *iconViewItem = static_cast<KFileIconViewItem*>( -[kfileItem extraData]( this ));
 </pre>

 This is usually more efficient then having every view associate data to
 items by using a separate QDict or QMap.

 Note: you have to remove and destroy the data you associated yourself
 when you don't need it anymore!

*/
- setExtraData: (void*)key value: (void*)value;

/** 

*/
- (void*) extraData: (void*)key;

/** 
 The non-const version of the previous @p -extraData method.
   
*/
- (void*) extraData: (void*)key;

/** 
 Removes the extra data associated with an item via @p key.
   
*/
- removeExtraData: (void*)key;
- setMetaInfo: (KFileMetaInfo*)info;
//- (KFileMetaInfo&) metaInfo;

/** 
 Somewhat like an assignment operator, but more explicit.
 Note: extra-data set with @ref -setExtraData is not copied, so be careful
 what you do!

 I.e. KDirLister uses it to update existing items from a fresh item.
   
*/
- assign: (KFileItem*)item;

/** 
 Computes the text, mode, and mimetype from the UDSEntry
 Called by constructor, but can be called again later
   
*/
- init: (BOOL)_determineMimeTypeOnDemand;

/** 
 Parses the given permission set and provides it for @ref -access
   
*/
- (NSString *) parsePermissions: (long)perm;
+ (int) Unknown;
@end

#endif
