/***************************************************************************
                            HTMLOptionElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLOPTIONELEMENT_H
#define HTMLOPTIONELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 A selectable choice. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html edef]-OPTION">
 OPTION element definition </a> in HTML 4.0.

 
 @short 
 A selectable choice.
*/
@class HTMLFormElement; 

@interface HTMLOptionElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
- (HTMLFormElement*) form;

/** 
 Stores the initial value of the <code> selected </code>
 attribute.

     
*/
- (BOOL) defaultSelected;

/** 
 see @ref defaultSelected
     
*/
- setDefaultSelected: (BOOL)arg1;

/** 
 The text contained within the option element.

     
*/
- (NSString *) text;

/** 
 The index of this <code> OPTION </code> in its parent <code>
 SELECT </code> .

     
*/
- (long) index;

/** 
 see @ref index

 This function is obsolete - the index property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
- setIndex: (long)arg1;

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) disabled;

/** 
 see @ref disabled
     
*/
- setDisabled: (BOOL)arg1;

/** 
 Option label for use in hierarchical menus. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-label-OPTION">
 label attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) label;

/** 
 see @ref label
     
*/
- setLabel: (NSString *)arg1;

/** 
 Means that this option is initially selected. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-selected">
 selected attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) selected;

/** 
 see @ref selected
     
*/
- setSelected: (BOOL)arg1;

/** 
 The current form control value. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-value-OPTION">
 value attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) value;

/** 
 see @ref value
     
*/
- setValue: (NSString *)arg1;
@end

#endif
