/***************************************************************************
                            HTMLHRElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLHRELEMENT_H
#define HTMLHRELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Create a horizontal rule. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html edef]-HR">
 HR element definition </a> in HTML 4.0.

 
 @short 
 Create a horizontal rule.
*/

@interface HTMLHRElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Align the rule on the page. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-align-HR">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Indicates to the user agent that there should be no shading in
 the rendering of this element. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-noshade">
 noshade attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
- (BOOL) noShade;

/** 
 see @ref noShade
     
*/
- setNoShade: (BOOL)arg1;

/** 
 The height of the rule. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-size-HR">
 size attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) size;

/** 
 see @ref size
     
*/
- setSize: (NSString *)arg1;

/** 
 The width of the rule. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-width-HR">
 width attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) width;

/** 
 see @ref width
     
*/
- setWidth: (NSString *)arg1;
@end

#endif
