/***************************************************************************
                            KXYSelector.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values. The currently chosen value is indicated
 by a cross. An example is the {@link KHSSelector} which
 allows to choose from a range of colors, and which is
 used in KColorDialog.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 See {@link KXYSelectorSignals} for signals emitted by KXYSelector.

 See {@link KXYSelectorEventHandling} for event handlers to override in subclasses of KXYSelector.

 @short 
 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values.
*/
public class KXYSelector extends QWidget  {
	protected KXYSelector(Class dummy){super((Class) null);}

	private native void newKXYSelector( QWidget parent, String name);

/** 
 Constructs a two-dimensional selector widget which
 has a value range of [0..100] in both directions.
   
*/
	public KXYSelector( QWidget parent, String name) {
		super((Class) null);
		newKXYSelector( parent, name);
	}
	private native void newKXYSelector();
	public KXYSelector() {
		super((Class) null);
		newKXYSelector();
	}

/** 
 Destructs the widget.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the current values in horizontal and
 vertical direction.
   
*/
	public native void setValues( int xPos, int yPos);

/** 
 Sets the range of possible values.
   
*/
	public native void setRange( int minX, int minY, int maxX, int maxY);

/** 

*/
	public native int xValue();

/** 

*/
	public native int yValue();

/** 

*/
	public native QRect contentsRect();

/** 
 Override this function to draw the contents of the widget.
 The default implementation doesn nothing.

 Draw within contentsRect() only.
   
*/
	protected native void drawContents( QPainter arg1);

/** 
 Override this function to draw the cursor which
 indicates the currently selected value pair.
   
*/
	protected native void drawCursor( QPainter p, int xp, int yp);
}
