package org.kde.koala;
import org.kde.qt.*;


/** {@link KTextBrowser} emits these signals */
public interface KTextBrowserSignals {
	void currentVerticalAlignmentChanged( int a );

/** 
 Emitted when a mail link has been activated and the widget has
 been configured to emit the signal.

*/
	void mailClick( String name, String address );
	void destroyed( QObject obj );
	void returnPressed();
	void contentsMoving( int x, int y );
	void currentFontChanged( QFont f );
	void currentColorChanged( QColor c );
	void undoAvailable( boolean yes );
	void highlighted( String arg1 );
	void currentAlignmentChanged( int a );
	void copyAvailable( boolean arg1 );
	void cursorPositionChanged( int para, int pos );
	void backwardAvailable( boolean arg1 );
	void modificationChanged( boolean m );
	void forwardAvailable( boolean arg1 );

/** 
 Emitted if {@link KTextBrowser#mailClick} is not emitted and the widget has been
 configured to emit the signal.

*/
	void urlClick( String url );
	void selectionChanged();
	void linkClicked( String arg1 );
	void redoAvailable( boolean yes );
	void textChanged();
}

