/***************************************************************************
                            KStartupInfoId.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Class representing an identification of application startup notification.

 Every existing notification about a starting application has its own unique
 identification, that's used to identify and manipulate the notification.

 @author Lubos Lunak <l.lunak@kde.org>

 @version $Id: KStartupInfoId.java,v 1.3 2002/01/31 04:49:01 rdale Exp $
 
 @short 
 Class representing an identification of application startup notification.
*/
public class  KStartupInfoId implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KStartupInfoId(Class dummy){}


/** 

*/
	public native boolean none();

/** 
 Initializes this object with the given identification ( which may be also "0"
 for no notification ), or if "" is given, tries to read it from the startup
 notification environment variable, and if it's not set, creates a new one.
	 
*/
	public native void initId( String identifier);
	public native void initId();

/** 

*/
	public native String id();

/** 
 Sets the startup notification environment variable to this identification.
	 
*/
	public native boolean setupStartupEnv();
	private native void newKStartupInfoId();

/** 
 Creates an empty identification
	 
*/
	public KStartupInfoId() {
		newKStartupInfoId();
	}
	private native void newKStartupInfoId( KStartupInfoId data);
	public KStartupInfoId( KStartupInfoId data) {
		newKStartupInfoId( data);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
}
