/***************************************************************************
                            KLibLoader.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KLibLoader allows you to load libraries dynamically at runtime.
 Dependent libraries are loaded automatically.

 KLibLoader follows the singleton pattern. You can not create multiple
 instances. Use {@link #self} to get a pointer to the loader.

 See {@link KLibLoaderSignals} for signals emitted by KLibLoader.

 See {@link KLibLoaderEventHandling} for event handlers to override in subclasses of KLibLoader.

 @author Torben Weis <weis@kde.org>
 
 @short 
 The KLibLoader allows you to load libraries dynamically at runtime.
*/
public class KLibLoader extends QObject  {
	protected KLibLoader(Class dummy){super((Class) null);}


/** 
 You should NEVER destruct an instance of KLibLoader
 until you know what you are doing. This will release
 the loaded libraries.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.

 This is a convenience function that returns the factory immediately

*/
	public native KLibFactory factory( String libname);

/** 
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)

*/
	public native KLibrary library( String libname);

/** 
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.   The library is loaded such that the symbols are
 globally accessible so libraries with dependencies can be loaded
 sequentially.

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)

*/
	public native KLibrary globalLibrary( String name);
	public native String lastErrorMessage();
	public native void unloadLibrary( String libname);

/** 

*/
	public static native KLibLoader self();

/** 

 This is what makes it possible to rely on ~KLibFactory
 being called in all cases, whether the library is unloaded
 while the application is running or when exiting.
     
*/
	public static native void cleanUp();

/** 
 Helper method which looks for a library in the standard paths
 ("module" and "lib" resources)
 Made public for code that doesn't use KLibLoader itself, but still
 wants to open modules.
     
*/
	public static native String findLibrary( String name, KInstanceInterface instance);
	public static native String findLibrary( String name);
	private native void newKLibLoader( QObject parent, String name);
	public KLibLoader( QObject parent, String name) {
		super((Class) null);
		newKLibLoader( parent, name);
	}
	private native void newKLibLoader();
	public KLibLoader() {
		super((Class) null);
		newKLibLoader();
	}
}
