/***************************************************************************
                            KConfig.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


Copyright (c) 2000 Matthias Elter

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


 See {@link KConfigSignals} for signals emitted by KConfig.

 See {@link KConfigEventHandling} for event handlers to override in subclasses of KConfig.

 @short 

*/
public class KConfig extends KConfigBase  {
	protected KConfig(Class dummy){super((Class) null);}

	private native void newKConfig( String fileName, boolean bReadOnly, boolean bUseKDEGlobals, String resType);

/** 
 Constructs a KConfig object.

*/
	public KConfig( String fileName, boolean bReadOnly, boolean bUseKDEGlobals, String resType) {
		super((Class) null);
		newKConfig( fileName, bReadOnly, bUseKDEGlobals, resType);
	}
	private native void newKConfig();
	public KConfig() {
		super((Class) null);
		newKConfig();
	}

/** 
 Destructs the KConfig object.

 Writes back any dirty configuration entries, and destroys
 dynamically created objects.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Clears all entries out of the <code>dirtyEntryMap</code>, so the
 values will not be written to disk on a later call to
 {@link #sync}.

*/
	public native void rollback( boolean bDeep);
	public native void rollback();

/** 
 Returns a list of groups that are known.
   
*/
	public native ArrayList groupList();

/** 
 Returns a map (tree) of entries for all entries in a particular
 group.

  Only the actual entry string is returned, none of the
 other internal data should be included.

*/
	public native String entryMap( String pGroup);

/** 
 Clears all internal data structures and then reread
 configuration information from disk.
   
*/
	public native void reparseConfiguration();

/** 
 Returns true if the specified group is known.

*/
	protected native boolean internalHasGroup( String group);

/** 
 Returns a map (tree) of the entries in the specified group.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//	protected native KEntryMap internalEntryMap( String pGroup);

/** 
 Returns a copy of the internal map used to hold all entries.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//	protected native KEntryMap internalEntryMap();

/** 
 Inserts a (key, value) pair into the internal storage mechanism of
 the configuration object.

*/
	protected native void putData( KEntryKey _key, KEntry _data, boolean _checkGroup);
	protected native void putData( KEntryKey _key, KEntry _data);

/** 
 Looks up an entry in the config object's internal structure.

*/
	protected native KEntry lookupData( KEntryKey _key);
}
