/***************************************************************************
                            KColorButton.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This widget can be used to display or allow user selection of a colour.

 See {@link KColorButtonSignals} for signals emitted by KColorButton.

 See {@link KColorButtonEventHandling} for event handlers to override in subclasses of KColorButton.

 @version $Id: KColorButton.java,v 1.5 2002/01/31 04:48:56 rdale Exp $

 @short A pushbutton to display or allow user selection of a colour.

*/
public class KColorButton extends QPushButton  {
	protected KColorButton(Class dummy){super((Class) null);}

	private native void newKColorButton( QWidget parent, String name);

/** 
 Creates a color button.
	 
*/
	public KColorButton( QWidget parent, String name) {
		super((Class) null);
		newKColorButton( parent, name);
	}
	private native void newKColorButton( QWidget parent);
	public KColorButton( QWidget parent) {
		super((Class) null);
		newKColorButton( parent);
	}
	private native void newKColorButton( QColor c, QWidget parent, String name);

/** 
 Creates a color button with an initial color <code>c.</code>
	 
*/
	public KColorButton( QColor c, QWidget parent, String name) {
		super((Class) null);
		newKColorButton( c, parent, name);
	}
	private native void newKColorButton( QColor c, QWidget parent);
	public KColorButton( QColor c, QWidget parent) {
		super((Class) null);
		newKColorButton( c, parent);
	}

/** 
 Destructor.
	 
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the currently chosen color.
	 
*/
	public native QColor color();

/** 
 Sets the current color to <code>c.</code>
	 
*/
	public native void setColor( QColor c);
	protected native void chooseColor();
}
