package org.kde.koala;
import org.kde.qt.*;


/** {@link KCModule} emits these signals */
public interface KCModuleSignals {
	void destroyed( QObject obj );

/** 
 Indicate that the state of the modules contents has changed.

 This signal is emitted whenever the state of the configuration
 shown in the module changes. It allows the control center to
 keep track of unsaved changes.

   
*/
	void changed( boolean state );

/** 
 Indicate that the module's quickhelp has changed.

 Emit this signal whenever the module's quickhelp changes.
 Modules implemented as tabbed dialogs might want to implement
 per-tab quickhelp for example.

   
*/
	void quickHelpChanged();
}

