/***************************************************************************
                            CharacterData.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The <code> CharacterData </code> interface extends Node with a set
 of attributes and methods for accessing character data in the DOM.
 For clarity this set is defined here rather than on each object
 that uses these attributes and methods. No DOM objects correspond
 directly to <code> CharacterData </code> , though <code> Text
 </code> and others do inherit the interface from it. All <code>
 offset</code>s in this interface start from 0.

 
 @short 
 The <code> CharacterData </code> interface extends Node with a set
 of attributes and methods for accessing character data in the DOM.
*/
public class CharacterData extends DOMNode  {
	protected CharacterData(Class dummy){super((Class) null);}

	private native void newCharacterData();
	public CharacterData() {
		super((Class) null);
		newCharacterData();
	}
	private native void newCharacterData( CharacterData other);
	public CharacterData( CharacterData other) {
		super((Class) null);
		newCharacterData( other);
	}
	private native void newCharacterData( DOMNode other);
	public CharacterData( DOMNode other) {
		super((Class) null);
		newCharacterData( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 The character data of the node that implements this interface.
 The DOM implementation may not put arbitrary limits on the
 amount of data that may be stored in a <code> CharacterData
 </code> node. However, implementation limits may mean that the
 entirety of a node's data may not fit into a single <code>
 DOMString </code> . In such cases, the user may call <code>
 substringData </code> to retrieve the data in appropriately
 sized pieces.

     
*/
	public native String data();

/** 
 see {@link data}

     
*/
	public native void setData( String arg1);

/** 
 The number of characters that are available through <code> data
 </code> and the <code> substringData </code> method below. This
 may have the value zero, i.e., <code> CharacterData </code>
 nodes may be empty.

     
*/
	public native long length();

/** 
 Extracts a range of data from the node.

  DOMSTRING_SIZE_ERR: Raised if the specified range of text does
 not fit into a <code> DOMString </code> .

     
*/
	public native String substringData( long offset, long count);

/** 
 Append the string to the end of the character data of the node.
 Upon success, <code> data </code> provides access to the
 concatenation of <code> data </code> and the <code> DOMString
 </code> specified.

     
*/
	public native void appendData( String arg);

/** 
 Insert a string at the specified character offset.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
	public native void insertData( long offset, String arg);

/** 
 Remove a range of characters from the node. Upon success,
 <code> data </code> and <code> length </code> reflect the
 change.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
	public native void deleteData( long offset, long count);

/** 
 Replace the characters starting at the specified character
 offset with the specified string.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
	public native void replaceData( long offset, long count, String arg);
}
