/***************************************************************************
                            kde_KToolBarPopupAction.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KTOOLBARPOPUPACTION
#define KDE_KTOOLBARPOPUPACTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu. This action is designed
 for history actions (back/forward, undo/redo) and for any other action
 that has more detail in a toolbar than in a menu (e.g. tool chooser
 with "Other" leading to a dialog...).
 
 @short 
 This action is a normal action everywhere, except in a toolbar
 where it also has a delayed popupmenu.
*/

/** 
 Create a KToolBarPopupAction, with a text, an icon, an optionnal accelerator,
 parent and name.

*/
kde_KToolBarPopupAction * kde_new_KToolBarPopupAction(qt_QString * text, qt_QString * icon, kde_KShortcut* cut, qt_QObject * parent, char* name);

/** 
 Create a KToolBarPopupAction, with a text, an icon, an accelerator,
 a slot connected to the action, parent and name.

 If you do not want or have a keyboard accelerator, set the
 @p accel param to 0.

*/
kde_KToolBarPopupAction * kde_new_KToolBarPopupAction1(qt_QString * text, qt_QString * icon, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name);

/** 
 Create a KToolBarPopupAction, with a KGuiItem, an accelerator,
 a slot connected to the action, parent and name. The text and the
 icon are taken from the KGuiItem.

 If you do not want or have a keyboard accelerator, set the
 @p accel param to 0.

*/
kde_KToolBarPopupAction * kde_new_KToolBarPopupAction2(kde_KGuiItem* item, kde_KShortcut* cut, qt_QObject * receiver, char* slot, kde_KActionCollection* parent, char* name);
void kde_del_KToolBarPopupAction( kde_KToolBarPopupAction* p );
int kde_KToolBarPopupAction_plug(kde_KToolBarPopupAction* instPointer,qt_QWidget * widget, int index);
void kde_KToolBarPopupAction_unplug(kde_KToolBarPopupAction* instPointer,qt_QWidget * widget);

/** 
 The popup menu that is shown when clicking (some time) on the toolbar
 button. You may want to plug items into it on creation, or connect to
 aboutToShow for a more dynamic menu.
     
*/
kde_KPopupMenu* kde_KToolBarPopupAction_popupMenu(kde_KToolBarPopupAction* instPointer);

/** 
 Returns true if this action creates a delayed popup menu
 when plugged in a KToolbar.
     
*/
int kde_KToolBarPopupAction_delayed(kde_KToolBarPopupAction* instPointer);

/** 
 If set to true, this action will create a delayed popup menu
 when plugged in a KToolbar. Otherwise it creates a normal popup.
 Default: delayed.
     
*/
void kde_KToolBarPopupAction_setDelayed(kde_KToolBarPopupAction* instPointer,int delayed);

/** 
 Returns true if this action creates a sticky popup menu.
 See @ref setStickyMenu.
     
*/
int kde_KToolBarPopupAction_stickyMenu(kde_KToolBarPopupAction* instPointer);

/** 
 If set to true, this action will create a sticky popup menu
 when plugged in a KToolbar.
 "Sticky", means it's visible until a selection is made or the mouse is
 clicked elsewhere. This feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.
 Only available if delayed() is true.
 Default: sticky.
     
*/
void kde_KToolBarPopupAction_setStickyMenu(kde_KToolBarPopupAction* instPointer,int sticky);

#endif
