/***************************************************************************
                            kde_KPopupMenu.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPOPUPMENU
#define KDE_KPOPUPMENU

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 KPopupMenu is a class for menus with standard title items. It acts
 identically to QPopupMenu, with the addition of insertTitle() and
 changeTitle() methods.

 The titles support a text string, an icon, plus user defined gradients,
 colors, and background pixmaps.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short A menu with title items.

*/

/** 
 Constructs a KPopupMenu.
     
*/
kde_KPopupMenu * kde_new_KPopupMenu(qt_QWidget * parent, char* name);

/** 
 Destructs the object
     
*/
void kde_del_KPopupMenu( kde_KPopupMenu* p );

/** 
 Inserts a title item with no icon.
     
*/
int kde_KPopupMenu_insertTitle(kde_KPopupMenu* instPointer,qt_QString * text, int identifier, int index);

/** 
 Inserts a title item with the given icon and title.
     
*/
int kde_KPopupMenu_insertTitle1(kde_KPopupMenu* instPointer,qt_QPixmap * icon, qt_QString * text, int identifier, int index);

/** 
 Changes the title of the item at the specified id. If a icon was
 previously set it is cleared.
     
*/
void kde_KPopupMenu_changeTitle(kde_KPopupMenu* instPointer,int identifier, qt_QString * text);

/** 
 Changes the title and icon of the title item at the specified id.
     
*/
void kde_KPopupMenu_changeTitle1(kde_KPopupMenu* instPointer,int identifier, qt_QPixmap * icon, qt_QString * text);

/** 
 Returns the title of the title item at the specified id. The default
 id of -1 is for backwards compatibility only, you should always specify
 the id.
     
*/
qt_QString * kde_KPopupMenu_title(kde_KPopupMenu* instPointer,int identifier);

/** 
 Returns the icon of the title item at the specified id.
     
*/
qt_QPixmap * kde_KPopupMenu_titlePixmap(kde_KPopupMenu* instPointer,int identifier);

/** 
 Obsolete method provided for backwards compatibility only. Use the
 normal constructor and insertTitle instead.
     
*/
kde_KPopupMenu * kde_new_KPopupMenu1(qt_QString * title, qt_QWidget * parent, char* name);

/** 
 Obsolete method provided for backwards compatibility only. Use
 insertTitle and changeTitle instead.
     
*/
void kde_KPopupMenu_setTitle(kde_KPopupMenu* instPointer,qt_QString * title);

#endif
