/***************************************************************************
                            kde_KLibrary.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLIBRARY
#define KDE_KLIBRARY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**


 KLibrary allows you to look up symbols of the shared library.

 @author Torben Weis <weis@kde.org>
 
 @short Represents a dynamically loaded library.

*/

/** 

 Don't create KLibrary objects on your own. Instead use @ref KLibLoader.
     
*/
kde_KLibrary * kde_new_KLibrary(qt_QString * libname, qt_QString * filename, void* handle);

/** 

*/
qt_QString * kde_KLibrary_name(kde_KLibrary* instPointer);

/** 

*/
qt_QString * kde_KLibrary_fileName(kde_KLibrary* instPointer);

/** 

*/
kde_KLibFactory* kde_KLibrary_factory(kde_KLibrary* instPointer);

/** 
 Looks up a symbol from the library. This is a very low level
 function that you usually don't want to use.
     
*/
void* kde_KLibrary_symbol(kde_KLibrary* instPointer,char* name);

/** 
 Unloads the library. 
 This typically results in the deletion of this object. You should
 not reference its pointer after calling this function.
     
*/
void kde_KLibrary_unload(kde_KLibrary* instPointer);

#endif
