/***************************************************************************
                            kde_KJavaProcess.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KJAVAPROCESS
#define KDE_KJAVAPROCESS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>


/** 
 Creates a process object, the process is NOT invoked at this point.
 You should first set the process's parameters, and then call startJava.
     
*/
kde_KJavaProcess * kde_new_KJavaProcess();
void kde_del_KJavaProcess( kde_KJavaProcess* p );

/** 
 Invoke the JVM with the parameters that have been set.  The Java process
 will start after this call.
     
*/
int kde_KJavaProcess_startJava(kde_KJavaProcess* instPointer);

/** 
 Stop the JVM (if it's running).
     
*/
void kde_KJavaProcess_stopJava(kde_KJavaProcess* instPointer);

/** 
 Returns the status of the java Process- true if it's ok, false if it has died.
 It calls KProcess::isRunning()
     
*/
int kde_KJavaProcess_isRunning(kde_KJavaProcess* instPointer);

/** 
 Used to specify the path to the Java executable to be run.
     
*/
void kde_KJavaProcess_setJVMPath(kde_KJavaProcess* instPointer,qt_QString * path);

/** 
 This will set the classpath the Java process will use.  It's used as a the
 -cp command line option.  It adds every jar file stored in $KDEDIRS/share/apps/kjava/
 to the classpath, and then adds the $CLASSPATH environmental variable.  This allows
 users to simply drop the JSSE (Java Secure Sockets Extension classes into that directory
 without having to modify the jvm configuration files.
     
*/
void kde_KJavaProcess_setClasspath(kde_KJavaProcess* instPointer,qt_QString * classpath);

/** 
 Set a property on the java command line as -Dname=value, or -Dname if value is QString::null.
 For example, you could call setSystemProperty( "kjas.debug", "" ) to set the kjas.debug property.
     
*/
void kde_KJavaProcess_setSystemProperty(kde_KJavaProcess* instPointer,qt_QString * name, qt_QString * value);

/** 
 The class to be called when startJava() is called.
     
*/
void kde_KJavaProcess_setMainClass(kde_KJavaProcess* instPointer,qt_QString * clazzName);

/** 
 Extra flags passed to the JVM.
     
*/
void kde_KJavaProcess_setExtraArgs(kde_KJavaProcess* instPointer,qt_QString * args);

/** 
 Arguments passed to the main class.  They will be very last in the java
 command line, after the main class.
     
*/
void kde_KJavaProcess_setClassArgs(kde_KJavaProcess* instPointer,qt_QString * classArgs);

/** 
 Sends a command to the KJAS Applet Server by building a QByteArray
 out of the data, and then writes it standard out.
     
*/
void kde_KJavaProcess_send(kde_KJavaProcess* instPointer,char cmd_code, qt_QStringList* args);

/** 
 Sends a command to the KJAS Applet Server by building a QByteArray
 out of the data, and then writes it standard out.  It adds each QString
 in the arg list, and then adds the data array.
     
*/
void kde_KJavaProcess_send1(kde_KJavaProcess* instPointer,char cmd_code, qt_QStringList* args, qt_QByteArray* data);
int kde_KJavaProcess_invokeJVM(kde_KJavaProcess* instPointer);
void kde_KJavaProcess_killJVM(kde_KJavaProcess* instPointer);
qt_QByteArray* kde_KJavaProcess_addArgs(kde_KJavaProcess* instPointer,char cmd_code, qt_QStringList* args);
void kde_KJavaProcess_popBuffer(kde_KJavaProcess* instPointer);
void kde_KJavaProcess_sendBuffer(kde_KJavaProcess* instPointer,qt_QByteArray* buff);
void kde_KJavaProcess_storeSize(kde_KJavaProcess* instPointer,qt_QByteArray* buff);

/** 
 This slot is called whenever something is written to stdin of the process.
 It's called again to make sure we keep emptying out the buffer that contains
 the messages we need send.
     
*/
void kde_KJavaProcess_slotWroteData(kde_KJavaProcess* instPointer);

/** 
 This slot is called when the Java Process writes to standard out.  We then
 process the data from the file descriptor that is passed to us and send the
 command to the AppletServer
     
*/
void kde_KJavaProcess_slotReceivedData(kde_KJavaProcess* instPointer,int arg1, int arg2);

#endif
