/***************************************************************************
                            kde_KHelpMenu.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KHELPMENU
#define KDE_KHELPMENU

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This class provides the standard KDE help menu with the default "about"
 dialog boxes and help entry.

 This class is used in @ref KMainWindow so
 normally you don't need to use this class yourself. However, if you
 need the help menu or any of its dialog boxes in your code that is
 not subclassed from @ref KMainWindow you should use this class.

 The usage is simple:

 <pre>
 mHelpMenu = new KHelpMenu( this, <someText> );
 kmenubar->insertItem(i18n("&Help"), mHelpMenu->menu() );
 </pre>

 or if you just want to open a dialog box:

 <pre>
 mHelpMenu = new KHelpMenu( this, <someText> );
 connect( this, SIGNAL(someSignal()), mHelpMenu,SLOT(mHelpMenu->aboutKDE()));
 </pre>

 IMPORTANT:
 The first time you use @ref KHelpMenu::menu(), a @ref KPopupMenu object is
 allocated. Only one object is created by the class so if you call
 @ref KHelpMenu::menu() twice or more, the same pointer is returned. The class
 will destroy the popupmenu in the destructor so do not delete this
 pointer yourself.

 The KHelpMenu object will be deleted when its parent is destroyed but you
 can delete it yourself if you want. The code below will always work.

 <pre>
 MyClass::~MyClass()
 {
   delete mHelpMenu;
 }
 </pre>

 Using your own "about application" dialog box:

 The standard "about application" dialog box is quite simple. If you
 need a dialog box with more functionality you must design that one
 yourself. When you want to display the dialog you can choose one of
 two methods. Common for both is that you must make a help menu object
 with no text argument If the text is missing the default dialog box
 will not be displayed:

 Example 1 Using @ref showAboutApplication signal (preferred)
 <pre>

 void MyClass::myFunc()
 {
   ..
   KHelpMenu *helpMenu = new KHelpMenu( this );
   connect( helpMenu, SIGNAL(showAboutApplication()),
          this, SLOT(myDialogSlot()));
   ..
 }

 void MyClass::myDialogSlot()
 {
   <activate your custom dialog>
 }
 </pre>

 Example 2 Old style - connecting directly to the menu entry.
 <pre>

 void MyClass::myFunc()
 {
   KHelpMenu *helpMenu = new KHelpMenu( this );
   KPopupMenu *help = mHelpMenu->menu();
   help->connectItem( KHelpMenu::menuAboutApp, this, SLOT(myDialogSlot()) );
 }

 void MyClass::myDialogSlot()
 {
   <activate your custom dialog>
 }
 </pre>

 @author Espen Sand (espen@kde.org)

 @version $Id: kde_KHelpMenu.h,v 1.3 2002/02/21 00:43:10 rdale Exp $
 
 @short Standard KDE help menu with dialog boxes.

*/
#define KHELPMENU_menuHelpContents	0
#define KHELPMENU_menuWhatsThis	1
#define KHELPMENU_menuAboutApp	2
#define KHELPMENU_menuAboutKDE	3
#define KHELPMENU_menuReportBug	4

/** 
 Constructor.

     
*/
kde_KHelpMenu * kde_new_KHelpMenu(qt_QWidget * parent, qt_QString * aboutAppText, int showWhatsThis);

/** 
 Constructor.

     
*/
kde_KHelpMenu * kde_new_KHelpMenu1(qt_QWidget * parent, kde_KAboutData* aboutData, int showWhatsThis, kde_KActionCollection* actions);

/** 
 Destructor

 Destroys dialogs and the menu pointer retuned by @ref menu
     
*/
void kde_del_KHelpMenu( kde_KHelpMenu* p );

/** 
 Returns a popup menu you can use in the menu bar or where you
 need it.

 Note: This method will only create one instance of the menu. If
 you call this method twice or more the same pointer is returned
     
*/
kde_KPopupMenu* kde_KHelpMenu_menu(kde_KHelpMenu* instPointer);

/** 
 Opens the help page for the application. The application name is
 used as a key to determine what to display and the system will attempt
 to open <appName>/index.html.
     
*/
void kde_KHelpMenu_appHelpActivated(kde_KHelpMenu* instPointer);

/** 
 Activates What's This help for the application.
     
*/
void kde_KHelpMenu_contextHelpActivated(kde_KHelpMenu* instPointer);

/** 
 Opens an application specific dialog box. The dialog box will display
 the string that was defined in the constructor. If that string was
 empty the @ref showAboutApplication() is emitted instead.
     
*/
void kde_KHelpMenu_aboutApplication(kde_KHelpMenu* instPointer);

/** 
 Opens the standard "About KDE" dialog box.
     
*/
void kde_KHelpMenu_aboutKDE(kde_KHelpMenu* instPointer);

/** 
 Opens the standard "Report Bugs" dialog box.
     
*/
void kde_KHelpMenu_reportBug(kde_KHelpMenu* instPointer);

#endif
