/***************************************************************************
                            kde_KGlobal.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KGLOBAL
#define KDE_KGLOBAL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Access to the KDE global objects.

 @author Sirtaj Singh Kang (taj@kde.org)

 @version $Id: kde_KGlobal.h,v 1.3 2002/02/21 00:43:10 rdale Exp $
 
 @short 
 Access to the KDE global objects.
*/

/** 
 Returns the global instance.  There is always at least
 one instance of a component in one application (in most
 cases the application itself).
     
*/
kde_KInstance* kde_KGlobal_instance( );

/** 
  Returns the application standard dirs object.
     
*/
kde_KStandardDirs* kde_KGlobal_dirs( );

/** 
  Returns the general config object.
     
*/
kde_KConfig* kde_KGlobal_config( );

/** 
  Returns an iconloader object.
     
*/
kde_KIconLoader* kde_KGlobal_iconLoader( );
kde_KLocale* kde_KGlobal_locale( );
kde_KCharsets* kde_KGlobal_charsets( );

/** 
 Creates a static QString.

 To be used inside functions(!) like:
 static const QString &myString = KGlobal::staticQString("myText");

 !!! Do _NOT_ use: !!!
 static QString myString = KGlobal::staticQString("myText");
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.
     
*/
qt_QString * kde_KGlobal_staticQString( char* arg1);

/** 
 Creates a static QString.

 To be used inside functions(!) like:
 static const QString &myString = KGlobal::staticQString(i18n("My Text"));

 !!! Do _NOT_ use: !!!
 static QString myString = KGlobal::staticQString(i18n("myText"));
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.
     
*/
qt_QString * kde_KGlobal_staticQString1( qt_QString * arg1);
void kde_KGlobal_registerStaticDeleter( kde_KStaticDeleterBase* arg1);
void kde_KGlobal_unregisterStaticDeleter( kde_KStaticDeleterBase* arg1);
void kde_KGlobal_deleteStaticDeleters( );

/** 
 The instance currently active (useful in a multi-instance
 application, such as a KParts application).
 Don't use this - it's mainly for KAboutDialog and KBugReport.
     
*/
void kde_KGlobal_setActiveInstance( kde_KInstance* d);
kde_KInstance* kde_KGlobal_activeInstance( );

#endif
