/***************************************************************************
                            kde_KFileItem.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILEITEM
#define KDE_KFILEITEM

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A KFileItem is a generic class to handle a file, local or remote.
 In particular, it makes it easier to handle the result of KIO::listDir.
 (UDSEntry isn't very friendly to use)
 It includes many file attributes such as mimetype, icon, text, mode, link...
 
 @short 
 A KFileItem is a generic class to handle a file, local or remote.
*/
#define KFILEITEM_Unknown	(mode_t)-1

/** 
 Creates an item representing a file, from a @ref UDSEntry.
 This is the preferred constructor when using KIO::listDir().

*/
//kde_KFileItem * kde_new_KFileItem(kde_UDSEntry* _entry, kde_KURL* _url, int _determineMimeTypeOnDemand, int _urlIsDirectory);

/** 
 Creates an item representing a file, from all the necessary info for it.

*/
kde_KFileItem * kde_new_KFileItem1(long _mode, long _permissions, kde_KURL* _url, int _determineMimeTypeOnDemand);

/** 
 Creates an item representing a file, for which the mimetype is already known.

*/
kde_KFileItem * kde_new_KFileItem2(kde_KURL* url, qt_QString * mimeType, long mode);

/** 
 Copy constructor. Note that extra-data set via @ref setExtraData() is not
 deeply copied -- just the pointers are copied.
   
*/
kde_KFileItem * kde_new_KFileItem3(kde_KFileItem* item);

/** 
 Destructs the KFileItem. Extra data set via setExtraData()
 is not deleted.
   
*/
void kde_del_KFileItem( kde_KFileItem* p );

/** 
 Re-reads information (currently only permissions and mimetype).
 This is called when the _file_ changes.
   
*/
void kde_KFileItem_refresh(kde_KFileItem* instPointer);

/** 
 Re-reads mimetype information.
 This is called when the mimetype database changes.
   
*/
void kde_KFileItem_refreshMimeType(kde_KFileItem* instPointer);

/** 
 Returns the url of the file.
   
*/
kde_KURL* kde_KFileItem_url(kde_KFileItem* instPointer);

/** 
 Sets the item's URL. Do not call unless you know what you are doing!
 (used for example when an item got renamed).
   
*/
void kde_KFileItem_setURL(kde_KFileItem* instPointer,kde_KURL* url);

/** 
 Returns the permissions of the file (stat.st_mode containing only permissions).
   
*/
long kde_KFileItem_permissions(kde_KFileItem* instPointer);

/** 
 Returns the access permissions for the file as a string.
   
*/
qt_QString * kde_KFileItem_permissionsString(kde_KFileItem* instPointer);

/** 
 Returns the file type (stat.st_mode containing only S_IFDIR, S_IFLNK, ...).
   
*/
long kde_KFileItem_mode(kde_KFileItem* instPointer);

/** 
 Returns the owner of the file.
   
*/
qt_QString * kde_KFileItem_user(kde_KFileItem* instPointer);

/** 
 Returns the group of the file.
   
*/
qt_QString * kde_KFileItem_group(kde_KFileItem* instPointer);

/** 
 Returns true if this item represents a link in the UNIX sense of
 a link.
   
*/
int kde_KFileItem_isLink(kde_KFileItem* instPointer);

/** 
 Returns true if this item represents a directory.
   
*/
int kde_KFileItem_isDir(kde_KFileItem* instPointer);

/** 
 Returns true if this item represents a file (and not a a directory)
   
*/
int kde_KFileItem_isFile(kde_KFileItem* instPointer);

/** 

*/
int kde_KFileItem_isReadable(kde_KFileItem* instPointer);

/** 
 Returns the link destination if isLink() == true.
   
*/
qt_QString * kde_KFileItem_linkDest(kde_KFileItem* instPointer);

/** 
 Returns the size of the file, if known.
   
*/
//KIO::filesize_t kde_KFileItem_size(kde_KFileItem* instPointer);

/** 

*/
long kde_KFileItem_time(kde_KFileItem* instPointer,unsigned int which);

/** 

*/
qt_QString * kde_KFileItem_timeString(kde_KFileItem* instPointer,unsigned int which);

/** 
 Returns true if the file is a local file.
   
*/
int kde_KFileItem_isLocalFile(kde_KFileItem* instPointer);

/** 
 Returns the text of the file item.
 It's not exactly the filename since some decoding happens ('%2F'->'/').
   
*/
qt_QString * kde_KFileItem_text(kde_KFileItem* instPointer);

/** 

*/
qt_QString * kde_KFileItem_name(kde_KFileItem* instPointer,int lowerCase);

/** 
 Returns the mimetype of the file item.
   
*/
qt_QString * kde_KFileItem_mimetype(kde_KFileItem* instPointer);

/** 
 Returns the mimetype of the file item.
 If determineMimeTypeOnDemand was used, this will determine the mimetype first.
   
*/
//kde_KMimeType_Ptr kde_KFileItem_determineMimeType(kde_KFileItem* instPointer);

/** 
 Returns the currently known mimetype of the file item.
 This will not try to determine the mimetype if unknown.
   
*/
//kde_KMimeType_Ptr kde_KFileItem_mimeTypePtr(kde_KFileItem* instPointer);
int kde_KFileItem_isMimeTypeKnown(kde_KFileItem* instPointer);

/** 
 Returns the descriptive comment for this mime type, or
 the mime type itself if none is present.
   
*/
qt_QString * kde_KFileItem_mimeComment(kde_KFileItem* instPointer);

/** 
 Returns the full path name to the icon that represents
 this mime type.
   
*/
qt_QString * kde_KFileItem_iconName(kde_KFileItem* instPointer);

/** 
 Returns a pixmap representing the file.

*/
qt_QPixmap * kde_KFileItem_pixmap(kde_KFileItem* instPointer,int _size, int _state);

/** 
 Returns the string to be displayed in the statusbar,
 e.g. when the mouse is over this item
   
*/
qt_QString * kde_KFileItem_getStatusBarInfo(kde_KFileItem* instPointer);

/** 

*/
qt_QString * kde_KFileItem_getToolTipText(kde_KFileItem* instPointer,int maxcount);

/** 
 Returns true if files can be dropped over this item.
 Contrary to popular belief, not only dirs will return true :)
 Executables, .desktop files, will do so as well.
   
*/
int kde_KFileItem_acceptsDrops(kde_KFileItem* instPointer);

/** 
 Let's "KRun" this file !
 (e.g. when file is clicked or double-clicked or return is pressed)
   
*/
void kde_KFileItem_run(kde_KFileItem* instPointer);

/** 
 Returns the UDS entry. Used by the tree view to access all details
 by position.
   
*/
//kde_UDSEntry* kde_KFileItem_entry(kde_KFileItem* instPointer);
int kde_KFileItem_isMarked(kde_KFileItem* instPointer);
void kde_KFileItem_mark(kde_KFileItem* instPointer);
void kde_KFileItem_unmark(kde_KFileItem* instPointer);

/** 
 Somewhat like a comparison operator, but more explicit
   
*/
int kde_KFileItem_cmp(kde_KFileItem* instPointer,kde_KFileItem* item);

/** 
 This allows to associate some "extra" data to a KFileItem. As one
 KFileItem can be used by several objects (often views) which all need
 to add some data, you have to use a key to reference your extra data
 within the KFileItem.

 That way a KFileItem can hold and provide access to all those views
 separately.

 I.e. a KFileIconView that associates a KFileIconViewItem (an item suitable
 for use with QIconView) does

 <pre>
 kfileItem->setExtraData( this, iconViewItem );
 </pre>

 and can later access the iconViewItem by doing

 <pre>
 KFileIconViewItem *iconViewItem = static_cast<KFileIconViewItem*>( kfileItem->extraData( this ));
 </pre>

 This is usually more efficient then having every view associate data to
 items by using a separate QDict or QMap.

 Note: you have to remove and destroy the data you associated yourself
 when you don't need it anymore!

*/
void kde_KFileItem_setExtraData(kde_KFileItem* instPointer,void* key, void* value);

/** 

*/
void* kde_KFileItem_extraData(kde_KFileItem* instPointer,void* key);

/** 
 The non-const version of the previous @p extraData() method.
   
*/
void* kde_KFileItem_extraData1(kde_KFileItem* instPointer,void* key);

/** 
 Removes the extra data associated with an item via @p key.
   
*/
void kde_KFileItem_removeExtraData(kde_KFileItem* instPointer,void* key);
//void kde_KFileItem_setMetaInfo(kde_KFileItem* instPointer,KFileMetaInfo info);
//KFileMetaInfo& kde_KFileItem_metaInfo(kde_KFileItem* instPointer);

/** 
 Somewhat like an assignment operator, but more explicit.
 Note: extra-data set with @ref setExtraData() is not copied, so be careful
 what you do!

 I.e. KDirLister uses it to update existing items from a fresh item.
   
*/
void kde_KFileItem_assign(kde_KFileItem* instPointer,kde_KFileItem* item);

/** 
 Computes the text, mode, and mimetype from the UDSEntry
 Called by constructor, but can be called again later
   
*/
void kde_KFileItem_init(kde_KFileItem* instPointer,int _determineMimeTypeOnDemand);

/** 
 Parses the given permission set and provides it for @ref access()
   
*/
qt_QString * kde_KFileItem_parsePermissions(kde_KFileItem* instPointer,long perm);

#endif
