/***************************************************************************
                            kde_KDialog.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDIALOG
#define KDE_KDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Dialog with extended modeless support and methods for KDE standard
 compliance.

 If the dialog is modeless and has a parent, the default keybindings 
 (@p escape = @p reject(), @p enter = @p accept(), etc.) are disabled.

 The @ref marginHint() and @ref spacingHint() sizes shall be used
 whenever you layout the interior of a dialog. One special note. If
 you make your own action buttons (OK, Cancel etc), the space
 beteween the buttons shall be @ref spacingHint(), whereas the space
 above, below, to the right and to the left shall be @ref marginHint().
 If you add a separator line above the buttons, there shall be a
 @ref marginHint() between the buttons and the separator and a
 @ref marginHint() above the separator as well.

 @author Thomas Tanghus <tanghus@earthling.net>, Espen Sand <espensa@online.no>

 @version 0.1.2

 @short 
 Dialog with extended modeless support and methods for KDE standard
 compliance.
*/

/** 
 Constructor. 

 Takes the same arguments as @ref QDialog.
     
*/
kde_KDialog * kde_new_KDialog(qt_QWidget * parent, char* name, int modal, int f);
void kde_KDialog_polish(kde_KDialog* instPointer);

/** 
 Make a KDE compliant caption.

*/
void kde_KDialog_setCaption(kde_KDialog* instPointer,qt_QString * caption);

/** 
 Make a plain caption without any modifications.

*/
void kde_KDialog_setPlainCaption(kde_KDialog* instPointer,qt_QString * caption);

/** 
 Return the number of pixels you shall use between a 
 dialog edge and the outermost widget(s) according to the KDE standard.

*/
int kde_KDialog_marginHint( );

/** 
 Return the number of pixels you shall use between 
 widgets inside a dialog according to the KDE standard.
     
*/
int kde_KDialog_spacingHint( );

/** 
 Resize every layout manager used in @p widget and its nested children.

*/
void kde_KDialog_resizeLayout( qt_QWidget * widget, int margin, int spacing);

/** 
 Reszie every layout associated with @p lay and its children. 

*/
void kde_KDialog_resizeLayout1( qt_QLayoutItem* lay, int margin, int spacing);

/** 

     
*/

#endif
