/***************************************************************************
                            kde_KArchive.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KARCHIVE
#define KDE_KARCHIVE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**


 @author David Faure <faure@kde.org>
 
 @short generic class for reading/writing archives.
*/

/** 
 Opens the archive for reading or writing.

*/
int kde_KArchive_open(kde_KArchive* instPointer,int mode);

/** 
 Closes the archive.
 Inherited classes might want to reimplement openArchive instead.

*/
void kde_KArchive_close(kde_KArchive* instPointer);

/** 

*/
int kde_KArchive_isOpened(kde_KArchive* instPointer);

/** 

*/
int kde_KArchive_mode(kde_KArchive* instPointer);

/** 
 The underlying device.
     
*/
qt_QIODevice * kde_KArchive_device(kde_KArchive* instPointer);

/** 
 If an archive is opened for reading, then the contents
 of the archive can be accessed via this function.
     
*/
kde_KArchiveDirectory* kde_KArchive_directory(kde_KArchive* instPointer);

/** 
 If an archive is opened for writing then you can add new directories
 using this function. KArchive won't write one directory twice.
     
*/
int kde_KArchive_writeDir(kde_KArchive* instPointer,qt_QString * name, qt_QString * user, qt_QString * group);

/** 
 If an archive is opened for writing then you can add a new file
 using this function. If the file name is for example "mydir/test1" then
 the directory "mydir" is automatically appended first if that did not
 happen yet.
     
*/
int kde_KArchive_writeFile(kde_KArchive* instPointer,qt_QString * name, qt_QString * user, qt_QString * group, unsigned int size, char* data);

/** 
 Here's another way of writing a file into an archive:
 Call @ref prepareWriting, then call write as many times as wanted,
 then call @ref doneWriting( totalSize )
 You need to know the size before hand, it is needed in the header!
     
*/
int kde_KArchive_prepareWriting(kde_KArchive* instPointer,qt_QString * name, qt_QString * user, qt_QString * group, unsigned int size);

/** 
 Call @ref doneWriting after writing the data.

*/
int kde_KArchive_doneWriting(kde_KArchive* instPointer,unsigned int size);

#endif
