/***************************************************************************
                            kde_KActionMenu.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KACTIONMENU
#define KDE_KACTIONMENU

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A KActionMenu is an action that holds a sub-menu of other actions.
 insert() and remove() allow to insert and remove actions into this action-menu.
 Plugged in a popupmenu, it will create a submenu.
 Plugged in a toolbar, it will create a button with a popup menu.

 This is the action used by the XMLGUI since it holds other actions.
 If you want a submenu for selecting one tool among many (without icons), see KSelectAction.
 See also setDelayed about the main action.
 
 @short 
 A KActionMenu is an action that holds a sub-menu of other actions.
*/
kde_KActionMenu * kde_new_KActionMenu(qt_QString * text, qt_QObject * parent, char* name);
kde_KActionMenu * kde_new_KActionMenu1(qt_QString * text, qt_QIconSet* icon, qt_QObject * parent, char* name);
kde_KActionMenu * kde_new_KActionMenu2(qt_QString * text, qt_QString * icon, qt_QObject * parent, char* name);
kde_KActionMenu * kde_new_KActionMenu3(qt_QObject * parent, char* name);
void kde_del_KActionMenu( kde_KActionMenu* p );
void kde_KActionMenu_insert(kde_KActionMenu* instPointer,kde_KAction* arg1, int index);
void kde_KActionMenu_remove(kde_KActionMenu* instPointer,kde_KAction* arg1);
kde_KPopupMenu* kde_KActionMenu_popupMenu(kde_KActionMenu* instPointer);
void kde_KActionMenu_popup(kde_KActionMenu* instPointer,qt_QPoint* global);

/** 
       Returns true if this action creates a delayed popup menu
       when plugged in a KToolbar.
     
*/
int kde_KActionMenu_delayed(kde_KActionMenu* instPointer);

/** 
       If set to true, this action will create a delayed popup menu
       when plugged in a KToolbar. Otherwise it creates a normal popup.
       Default: delayed

       Remember that if the "main" action (the toolbar button itself)
       cannot be clicked, then you should call setDelayed(false).

       On the opposite, if the main action can be clicked, it can only happen
       in a toolbar: in a menu, the parent of a submenu can't be activated.
       To get a "normal" menu item when plugged a menu (and no submenu)
       use KToolBarPopupAction.
    
*/
void kde_KActionMenu_setDelayed(kde_KActionMenu* instPointer,int _delayed);

/** 
 Returns true if this action creates a sticky popup menu.
 See @ref setStickyMenu.
     
*/
int kde_KActionMenu_stickyMenu(kde_KActionMenu* instPointer);

/** 
 If set to true, this action will create a sticky popup menu
 when plugged in a KToolbar.
 "Sticky", means it's visible until a selection is made or the mouse is
 clicked elsewhere. This feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.
 Default: sticky.
     
*/
void kde_KActionMenu_setStickyMenu(kde_KActionMenu* instPointer,int sticky);
int kde_KActionMenu_plug(kde_KActionMenu* instPointer,qt_QWidget * widget, int index);
void kde_KActionMenu_unplug(kde_KActionMenu* instPointer,qt_QWidget * widget);
void kde_KActionMenu_setEnabled(kde_KActionMenu* instPointer,int b);
void kde_KActionMenu_setText(kde_KActionMenu* instPointer,int identifier, qt_QString * text);
void kde_KActionMenu_setIconSet(kde_KActionMenu* instPointer,int identifier, qt_QIconSet* iconSet);
void kde_KActionMenu_setIconSet1(kde_KActionMenu* instPointer,qt_QIconSet* i);
void kde_KActionMenu_setText1(kde_KActionMenu* instPointer,qt_QString * s);

#endif
