#ifndef __pcop_h__
#define __pcop_h__

#include <Python.h>

#include <qcstring.h>
#include <qlist.h>
#include <qasciidict.h>

class QDataStream;

struct PCOPType
{
    PCOPType( const QCString& );
    ~PCOPType();

    QCString signature() const;

    PyObject* demarshal( QDataStream& str );
    bool marshal( PyObject* obj, QDataStream& str ) const;

    // checks if the given PyObject can be marshalled as this PCOPType
    bool isMarshallable( PyObject *obj );

    QCString m_type;
    PCOPType* m_leftType;
    PCOPType* m_rightType;
};

struct PCOPMethod
{
    PCOPMethod( const QCString& signature );
    ~PCOPMethod();

    int paramCount() const;
    QCString signature() const;
    PCOPType* param( int );
    const PCOPType* param( int ) const;

    QCString m_signature;
    QCString m_name;
    PCOPType* m_type;
    QList<PCOPType> m_params;
};

struct PCOPClass
{
    PCOPClass( const QCStringList& );
    ~PCOPClass();

    const PCOPMethod* method( const QCString &name, PyObject *argTuple = 0 );

    QCStringList m_ifaces;
    QAsciiDict<PCOPMethod> m_methods;
};

#endif
