/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.memory.model;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakObjectRegistry<E>
extends AbstractSet<E> {
    private final Map<E, WeakReference<E>> objectMap = new WeakHashMap<E, WeakReference<E>>();

    public WeakObjectRegistry() {
    }

    public WeakObjectRegistry(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public E get(Object key) {
        WeakReference<E> weakRef = this.objectMap.get(key);
        if (weakRef != null) {
            return (E)weakRef.get();
        }
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.objectMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.objectMap.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.get(o) != null;
    }

    @Override
    public boolean add(E object) {
        WeakReference<E> ref = new WeakReference<E>(object);
        if ((ref = this.objectMap.put(object, ref)) != null && ref.get() != null) {
            this.objectMap.put(ref.get(), ref);
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        WeakReference<E> ref = this.objectMap.remove(o);
        return ref != null && ref.get() != null;
    }

    @Override
    public void clear() {
        this.objectMap.clear();
    }
}

