/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.client;

import info.aduna.io.IOUtil;
import info.aduna.net.http.HttpClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.openrdf.OpenRDFUtil;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.http.protocol.error.ErrorInfo;
import org.openrdf.http.protocol.error.ErrorType;
import org.openrdf.http.protocol.transaction.TransactionWriter;
import org.openrdf.http.protocol.transaction.operations.TransactionOperation;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.impl.GraphQueryResultImpl;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.query.resultio.UnsupportedQueryResultFormatException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPClient {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ValueFactory valueFactory;
    private String serverURL;
    private String repositoryURL;
    private HttpClient httpClient;
    private AuthScope authScope;
    private TupleQueryResultFormat preferredTQRFormat = TupleQueryResultFormat.BINARY;
    private BooleanQueryResultFormat preferredBQRFormat = BooleanQueryResultFormat.TEXT;
    private RDFFormat preferredRDFFormat = RDFFormat.TURTLE;

    public HTTPClient() {
        this.valueFactory = ValueFactoryImpl.getInstance();
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(20);
        manager.setParams(params);
        this.httpClient = new HttpClient((HttpConnectionManager)manager);
    }

    protected final HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void setServerURL(String serverURL) {
        if (serverURL == null) {
            throw new IllegalArgumentException("serverURL must not be null");
        }
        this.serverURL = serverURL;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    protected void checkServerURL() {
        if (this.serverURL == null) {
            throw new IllegalStateException("Server URL has not been set");
        }
    }

    public void setRepositoryURL(String repositoryURL) {
        if (repositoryURL == null) {
            throw new IllegalArgumentException("repositoryURL must not be null");
        }
        this.repositoryURL = repositoryURL;
        Pattern urlPattern = Pattern.compile("(.*)/repositories/[^/]*/?");
        Matcher matcher = urlPattern.matcher(repositoryURL);
        if (matcher.matches() && matcher.groupCount() == 1) {
            this.setServerURL(matcher.group(1));
        }
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    protected void checkRepositoryURL() {
        if (this.repositoryURL == null) {
            throw new IllegalStateException("Repository URL has not been set");
        }
    }

    public void setRepositoryID(String repositoryID) {
        this.checkServerURL();
        this.repositoryURL = Protocol.getRepositoryLocation(this.serverURL, repositoryID);
    }

    public void setPreferredTupleQueryResultFormat(TupleQueryResultFormat format) {
        this.preferredTQRFormat = format;
    }

    public TupleQueryResultFormat getPreferredTupleQueryResultFormat() {
        return this.preferredTQRFormat;
    }

    public void setPreferredRDFFormat(RDFFormat format) {
        this.preferredRDFFormat = format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.preferredRDFFormat;
    }

    public void setPreferredBooleanQueryResultFormat(BooleanQueryResultFormat format) {
        this.preferredBQRFormat = format;
    }

    public BooleanQueryResultFormat getPreferredBooleanQueryResultFormat() {
        return this.preferredBQRFormat;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.checkServerURL();
        if (username != null && password != null) {
            this.logger.debug("Setting username '{}' and password for server at {}.", (Object)username, (Object)this.serverURL);
            try {
                URL server = new URL(this.serverURL);
                this.authScope = new AuthScope(server.getHost(), -1);
                this.httpClient.getState().setCredentials(this.authScope, (Credentials)new UsernamePasswordCredentials(username, password));
                this.httpClient.getParams().setAuthenticationPreemptive(true);
            }
            catch (MalformedURLException e) {
                this.logger.warn("Unable to set username and password for malformed URL {}", (Object)this.serverURL);
            }
        } else {
            this.authScope = null;
            this.httpClient.getState().clearCredentials();
            this.httpClient.getParams().setAuthenticationPreemptive(false);
        }
    }

    public String getServerProtocol() throws IOException, RepositoryException, UnauthorizedException {
        this.checkServerURL();
        GetMethod method = new GetMethod(Protocol.getProtocolLocation(this.serverURL));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 200) {
                String string = method.getResponseBodyAsString();
                return string;
            }
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
            throw new RepositoryException("Failed to get server protocol: " + errInfo);
        }
        finally {
            method.releaseConnection();
        }
    }

    public TupleQueryResult getRepositoryList() throws IOException, RepositoryException, UnauthorizedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getRepositoryList(builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getRepositoryList(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException {
        this.checkServerURL();
        GetMethod method = new GetMethod(Protocol.getRepositoriesLocation(this.serverURL));
        this.setDoAuthentication((HttpMethod)method);
        try {
            this.getTupleQueryResult((HttpMethod)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public TupleQueryResult sendTupleQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.sendTupleQuery(ql, query, dataset, includeInferred, builder, bindings);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTupleQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, TupleQueryResultHandler handler, Binding ... bindings) throws IOException, TupleQueryResultHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException {
        HttpMethod method = this.getQueryMethod(ql, query, dataset, includeInferred, bindings);
        try {
            this.getTupleQueryResult(method, handler);
        }
        finally {
            this.releaseConnection(method);
        }
    }

    public GraphQueryResult sendGraphQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException {
        try {
            StatementCollector collector = new StatementCollector();
            this.sendGraphQuery(ql, query, dataset, includeInferred, collector, bindings);
            return new GraphQueryResultImpl(collector.getNamespaces(), collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGraphQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, RDFHandler handler, Binding ... bindings) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException {
        HttpMethod method = this.getQueryMethod(ql, query, dataset, includeInferred, bindings);
        try {
            this.getRDF(method, handler, false);
        }
        finally {
            this.releaseConnection(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBooleanQuery(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException {
        HttpMethod method = this.getQueryMethod(ql, query, dataset, includeInferred, bindings);
        try {
            boolean bl = this.getBoolean(method);
            return bl;
        }
        finally {
            this.releaseConnection(method);
        }
    }

    protected HttpMethod getQueryMethod(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        PostMethod method = new PostMethod(this.getRepositoryURL());
        this.setDoAuthentication((HttpMethod)method);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        List<NameValuePair> queryParams = this.getQueryMethodParameters(ql, query, dataset, includeInferred, bindings);
        method.setRequestBody(queryParams.toArray(new NameValuePair[queryParams.size()]));
        return method;
    }

    protected List<NameValuePair> getQueryMethodParameters(QueryLanguage ql, String query, Dataset dataset, boolean includeInferred, Binding ... bindings) {
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(bindings.length + 10);
        queryParams.add(new NameValuePair("queryLn", ql.getName()));
        queryParams.add(new NameValuePair("query", query));
        queryParams.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
        if (dataset != null) {
            for (URI defaultGraphURI : dataset.getDefaultGraphs()) {
                queryParams.add(new NameValuePair("default-graph-uri", ((Object)defaultGraphURI).toString()));
            }
            for (URI namedGraphURI : dataset.getNamedGraphs()) {
                queryParams.add(new NameValuePair("named-graph-uri", ((Object)namedGraphURI).toString()));
            }
        }
        for (int i = 0; i < bindings.length; ++i) {
            String paramName = "$" + bindings[i].getName();
            String paramValue = Protocol.encodeValue(bindings[i].getValue());
            queryParams.add(new NameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    public void getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws IOException, RDFHandlerException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getStatementsLocation(this.getRepositoryURL()));
        this.setDoAuthentication((HttpMethod)method);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue(subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue(pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue(obj)));
        }
        for (String encodedContext : Protocol.encodeContexts(contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        params.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
        method.setQueryString(params.toArray(new NameValuePair[params.size()]));
        try {
            this.getRDF((HttpMethod)method, handler, true);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTransaction(final Iterable<? extends TransactionOperation> txn) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        PostMethod method = new PostMethod(Protocol.getStatementsLocation(this.getRepositoryURL()));
        this.setDoAuthentication((HttpMethod)method);
        method.setRequestEntity(new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                return "application/x-rdftransaction";
            }

            public boolean isRepeatable() {
                return true;
            }

            public void writeRequest(OutputStream out) throws IOException {
                TransactionWriter txnWriter = new TransactionWriter();
                txnWriter.serialize(txn, out);
            }
        });
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!HttpClientUtil.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Transaction failed: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public void upload(final Reader contents, String baseURI, final RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        final Charset charset = dataFormat.hasCharset() ? dataFormat.getCharset() : Charset.forName("UTF-8");
        RequestEntity entity = new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                return dataFormat.getDefaultMIMEType() + "; charset=" + charset.name();
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                IOUtil.transfer(contents, writer);
                writer.flush();
            }
        };
        this.upload(entity, baseURI, overwrite, contexts);
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        InputStreamRequestEntity entity = new InputStreamRequestEntity(contents, -1L, dataFormat.getDefaultMIMEType());
        this.upload((RequestEntity)entity, baseURI, overwrite, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(RequestEntity reqEntity, String baseURI, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.checkRepositoryURL();
        String uploadURL = Protocol.getStatementsLocation(this.getRepositoryURL());
        Object method = overwrite ? new PutMethod(uploadURL) : new PostMethod(uploadURL);
        this.setDoAuthentication((HttpMethod)method);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        for (String encodedContext : Protocol.encodeContexts(contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        if (baseURI != null && baseURI.trim().length() != 0) {
            String encodedBaseURI = Protocol.encodeValue(new URIImpl(baseURI));
            params.add(new NameValuePair("baseURI", encodedBaseURI));
        }
        method.setQueryString(params.toArray(new NameValuePair[params.size()]));
        method.setRequestEntity(reqEntity);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (httpCode == 415) {
                throw new UnsupportedRDFormatException(method.getResponseBodyAsString());
            }
            if (!HttpClientUtil.is2xx(httpCode)) {
                ErrorInfo errInfo = ErrorInfo.parse(method.getResponseBodyAsString());
                if (errInfo.getErrorType() == ErrorType.MALFORMED_DATA) {
                    throw new RDFParseException(errInfo.getErrorMessage());
                }
                if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_FILE_FORMAT) {
                    throw new UnsupportedRDFormatException(errInfo.getErrorMessage());
                }
                throw new RepositoryException("Failed to upload data: " + errInfo);
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public TupleQueryResult getContextIDs() throws IOException, RepositoryException, UnauthorizedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getContextIDs(builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getContextsLocation(this.getRepositoryURL()));
        this.setDoAuthentication((HttpMethod)method);
        try {
            this.getTupleQueryResult((HttpMethod)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public TupleQueryResult getNamespaces() throws IOException, RepositoryException, UnauthorizedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getNamespaces(builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getNamespacesLocation(this.repositoryURL));
        this.setDoAuthentication((HttpMethod)method);
        try {
            this.getTupleQueryResult((HttpMethod)method, handler);
        }
        catch (MalformedQueryException e) {
            this.logger.warn("Server reported unexpected malfored query error", (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public String getNamespace(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        GetMethod method = new GetMethod(Protocol.getNamespacePrefixLocation(this.repositoryURL, prefix));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 200) {
                String string = method.getResponseBodyAsString();
                return string;
            }
            if (httpCode == 404) {
                String string = null;
                return string;
            }
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
            throw new RepositoryException("Failed to get namespace: " + errInfo + " (" + httpCode + ")");
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespacePrefix(String prefix, String name) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        PutMethod method = new PutMethod(Protocol.getNamespacePrefixLocation(this.repositoryURL, prefix));
        this.setDoAuthentication((HttpMethod)method);
        method.setRequestEntity((RequestEntity)new StringRequestEntity(name, "text/plain", "UTF-8"));
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!HttpClientUtil.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Failed to set namespace: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespacePrefix(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        DeleteMethod method = new DeleteMethod(Protocol.getNamespacePrefixLocation(this.repositoryURL, prefix));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!HttpClientUtil.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Failed to remove namespace: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNamespaces() throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        DeleteMethod method = new DeleteMethod(Protocol.getNamespacesLocation(this.repositoryURL));
        this.setDoAuthentication((HttpMethod)method);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            if (!HttpClientUtil.is2xx(httpCode)) {
                ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
                throw new RepositoryException("Failed to clear namespaces: " + errInfo + " (" + httpCode + ")");
            }
        }
        finally {
            this.releaseConnection((HttpMethod)method);
        }
    }

    public long size(Resource ... contexts) throws IOException, RepositoryException, UnauthorizedException {
        this.checkRepositoryURL();
        String[] encodedContexts = Protocol.encodeContexts(contexts);
        NameValuePair[] contextParams = new NameValuePair[encodedContexts.length];
        for (int i = 0; i < encodedContexts.length; ++i) {
            contextParams[i] = new NameValuePair("context", encodedContexts[i]);
        }
        GetMethod method = new GetMethod(Protocol.getSizeLocation(this.repositoryURL));
        this.setDoAuthentication((HttpMethod)method);
        method.setQueryString(contextParams);
        try {
            int httpCode = this.httpClient.executeMethod((HttpMethod)method);
            if (httpCode == 200) {
                String response = method.getResponseBodyAsString();
                try {
                    long l = Long.parseLong(response);
                    return l;
                }
                catch (NumberFormatException e) {
                    throw new RepositoryException("Server responded with invalid size value: " + response);
                }
            }
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            ErrorInfo errInfo = this.getErrorInfo((HttpMethod)method);
            throw new RepositoryException(errInfo.toString());
        }
        finally {
            method.releaseConnection();
        }
    }

    protected void getTupleQueryResult(HttpMethod method, TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException {
        Set tqrFormats = TupleQueryResultParserRegistry.getInstance().getKeys();
        if (tqrFormats.isEmpty()) {
            throw new RepositoryException("No tuple query result parsers have been registered");
        }
        for (TupleQueryResultFormat format : tqrFormats) {
            int qValue = 10;
            if (this.preferredTQRFormat != null && !this.preferredTQRFormat.equals(format)) {
                qValue -= 2;
            }
            Iterator<String> i$ = format.getMIMETypes().iterator();
            while (i$.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = i$.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                method.addRequestHeader("Accept", acceptParam);
            }
        }
        int httpCode = this.httpClient.executeMethod(method);
        if (httpCode == 200) {
            String mimeType = this.getResponseMIMEType(method);
            try {
                TupleQueryResultFormat format = (TupleQueryResultFormat)TupleQueryResultFormat.matchMIMEType(mimeType, tqrFormats);
                TupleQueryResultParser parser = QueryResultIO.createParser(format, this.getValueFactory());
                parser.setTupleQueryResultHandler(handler);
                parser.parse(method.getResponseBodyAsStream());
            }
            catch (UnsupportedQueryResultFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
            catch (QueryResultParseException e) {
                throw new RepositoryException("Malformed query result from server", e);
            }
        } else {
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            ErrorInfo errInfo = this.getErrorInfo(method);
            if (errInfo.getErrorType() == ErrorType.MALFORMED_QUERY) {
                throw new MalformedQueryException(errInfo.getErrorMessage());
            }
            if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_QUERY_LANGUAGE) {
                throw new UnsupportedQueryLanguageException(errInfo.getErrorMessage());
            }
            throw new RepositoryException(errInfo.toString());
        }
    }

    protected void getRDF(HttpMethod method, RDFHandler handler, boolean requireContext) throws IOException, RDFHandlerException, RepositoryException, MalformedQueryException, UnauthorizedException {
        Set rdfFormats = RDFParserRegistry.getInstance().getKeys();
        if (rdfFormats.isEmpty()) {
            throw new RepositoryException("No tuple RDF parsers have been registered");
        }
        for (RDFFormat format : rdfFormats) {
            int qValue = 10;
            if (requireContext && !format.supportsContexts()) {
                qValue -= 5;
            }
            if (this.preferredRDFFormat != null && !this.preferredRDFFormat.equals(format)) {
                qValue -= 2;
            }
            if (!format.supportsNamespaces()) {
                --qValue;
            }
            Iterator<String> i$ = format.getMIMETypes().iterator();
            while (i$.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = i$.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                method.addRequestHeader("Accept", acceptParam);
            }
        }
        int httpCode = this.httpClient.executeMethod(method);
        if (httpCode == 200) {
            String mimeType = this.getResponseMIMEType(method);
            try {
                RDFFormat format = (RDFFormat)RDFFormat.matchMIMEType(mimeType, rdfFormats);
                RDFParser parser = Rio.createParser(format, this.getValueFactory());
                parser.setPreserveBNodeIDs(true);
                parser.setRDFHandler(handler);
                parser.parse(method.getResponseBodyAsStream(), method.getURI().getURI());
            }
            catch (UnsupportedRDFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
            catch (RDFParseException e) {
                throw new RepositoryException("Malformed query result from server", e);
            }
        } else {
            if (httpCode == 401) {
                throw new UnauthorizedException();
            }
            ErrorInfo errInfo = this.getErrorInfo(method);
            if (errInfo.getErrorType() == ErrorType.MALFORMED_QUERY) {
                throw new MalformedQueryException(errInfo.getErrorMessage());
            }
            if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_QUERY_LANGUAGE) {
                throw new UnsupportedQueryLanguageException(errInfo.getErrorMessage());
            }
            throw new RepositoryException(errInfo.toString());
        }
    }

    protected boolean getBoolean(HttpMethod method) throws IOException, RepositoryException, MalformedQueryException, UnauthorizedException {
        Set booleanFormats = BooleanQueryResultParserRegistry.getInstance().getKeys();
        if (booleanFormats.isEmpty()) {
            throw new RepositoryException("No boolean query result parsers have been registered");
        }
        for (BooleanQueryResultFormat format : booleanFormats) {
            int qValue = 10;
            if (this.preferredBQRFormat != null && !this.preferredBQRFormat.equals(format)) {
                qValue -= 2;
            }
            Iterator<String> i$ = format.getMIMETypes().iterator();
            while (i$.hasNext()) {
                String mimeType;
                String acceptParam = mimeType = i$.next();
                if (qValue < 10) {
                    acceptParam = acceptParam + ";q=0." + qValue;
                }
                method.addRequestHeader("Accept", acceptParam);
            }
        }
        int httpCode = this.httpClient.executeMethod(method);
        if (httpCode == 200) {
            String mimeType = this.getResponseMIMEType(method);
            try {
                BooleanQueryResultFormat format = (BooleanQueryResultFormat)BooleanQueryResultFormat.matchMIMEType(mimeType, booleanFormats);
                BooleanQueryResultParser parser = QueryResultIO.createParser(format);
                return parser.parse(method.getResponseBodyAsStream());
            }
            catch (UnsupportedQueryResultFormatException e) {
                throw new RepositoryException("Server responded with an unsupported file format: " + mimeType);
            }
            catch (QueryResultParseException e) {
                throw new RepositoryException("Malformed query result from server", e);
            }
        }
        if (httpCode == 401) {
            throw new UnauthorizedException();
        }
        ErrorInfo errInfo = this.getErrorInfo(method);
        if (errInfo.getErrorType() == ErrorType.MALFORMED_QUERY) {
            throw new MalformedQueryException(errInfo.getErrorMessage());
        }
        if (errInfo.getErrorType() == ErrorType.UNSUPPORTED_QUERY_LANGUAGE) {
            throw new UnsupportedQueryLanguageException(errInfo.getErrorMessage());
        }
        throw new RepositoryException(method.getStatusText());
    }

    protected String getResponseMIMEType(HttpMethod method) throws IOException {
        Header[] headers;
        for (Header header : headers = method.getResponseHeaders("Content-Type")) {
            HeaderElement[] headerElements;
            for (HeaderElement headerEl : headerElements = header.getElements()) {
                String mimeType = headerEl.getName();
                if (mimeType == null) continue;
                this.logger.debug("reponse MIME type is {}", (Object)mimeType);
                return mimeType;
            }
        }
        return null;
    }

    protected ErrorInfo getErrorInfo(HttpMethod method) throws RepositoryException {
        try {
            ErrorInfo errInfo = ErrorInfo.parse(method.getResponseBodyAsString());
            this.logger.warn("Server reports problem: {}", (Object)errInfo.getErrorMessage());
            return errInfo;
        }
        catch (IOException e) {
            this.logger.warn("Unable to retrieve error info from server");
            throw new RepositoryException("Unable to retrieve error info from server", e);
        }
    }

    protected final void setDoAuthentication(HttpMethod method) {
        if (this.authScope != null && this.httpClient.getState().getCredentials(this.authScope) != null) {
            method.setDoAuthentication(true);
        } else {
            method.setDoAuthentication(false);
        }
    }

    protected final void releaseConnection(HttpMethod method) {
        try {
            InputStream responseStream = method.getResponseBodyAsStream();
            if (responseStream != null) {
                while (responseStream.read() >= 0) {
                }
            }
            method.releaseConnection();
        }
        catch (IOException e) {
            this.logger.warn("I/O error upon releasing connection", (Throwable)e);
        }
    }
}

