/***************************************************************************
                            QTextCodec.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QTEXTCODEC_H
#define QTEXTCODEC_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

* $Id: QTextCodec.h,v 1.2 2001/11/21 23:39:02 rdale Exp $
*
* Definition of QTextStream class
*
* Created : 940922
*
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
*
* This file is part of the tools module of the Qt GUI Toolkit.
*
* This file may be distributed under the terms of the Q Public License
* as defined by Trolltech AS of Norway and appearing in the file
* LICENSE.QPL included in the packaging of this file.
*
* This file may be distributed and/or modified under the terms of the
* GNU General Public License version 2 as published by the Free Software
* Foundation and appearing in the file LICENSE.GPL included in the
* packaging of this file.
*
* Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
* licenses may use this file in accordance with the Qt Commercial License
* Agreement provided with the Software.
*
* This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
* WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
*   information about Qt Commercial License Agreements.
* See http://www.trolltech.com/qpl/ for QPL licensing information.
* See http://www.trolltech.com/gpl/ for GPL licensing information.
*
* Contact info@trolltech.com if any conditions of this licensing are
* not clear to you.
*
********************************************************************
 @short 
* $Id:  qt/qtextstream.
*/
@class QByteArray; 
@class QIODevice; 
@class QTextDecoder; 
@class QTextEncoder; 

@interface  QTextCodec : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- (void) dealloc;
- (NSString *) name;
- (NSString *) mimeName;
- (int) mibEnum;
- (QTextDecoder*) makeDecoder;
- (QTextEncoder*) makeEncoder;
- (NSString *) toUnicode: (NSString *)chars len: (int)len;
- (NSString *) fromUnicode: (NSString *)uc lenInOut: (int)lenInOut;
- (NSString *) fromUnicode: (NSString *)uc;
//- (NSString *) toUnicodeFromByteArray: (QByteArray*)arg1 len: (int)len;
//- (NSString *) toUnicodeFromByteArray: (QByteArray*)arg1;
//- (NSString *) toUnicode: (NSString *)arg1 len: (int)len;
- (NSString *) toUnicode: (NSString *)arg1;
//- (NSString *) toUnicode: (NSString *)chars;
- (BOOL) canEncodeUnichar: (unichar *)arg1;
- (BOOL) canEncodeString: (NSString *)arg1;
- (int) heuristicContentMatch: (NSString *)chars len: (int)len;
- (int) heuristicNameMatch: (NSString *)hint;
- (QByteArray*) fromUnicode: (NSString *)uc from: (int)from len: (int)len;
- (unsigned short) characterFromUnicode: (NSString *)str pos: (int)pos;
+ (QTextCodec*) loadCharmap: (QIODevice *)arg1;
+ (QTextCodec*) loadCharmapFile: (NSString *)filename;
+ (QTextCodec*) codecForMib: (int)mib;
+ (QTextCodec*) codecForName: (NSString *)hint accuracy: (int)accuracy;
+ (QTextCodec*) codecForName: (NSString *)hint ;
+ (QTextCodec*) codecForContent: (NSString *)chars len: (int)len;
+ (QTextCodec*) codecForIndex: (int)i;
+ (QTextCodec*) codecForLocale;
+ setCodecForLocale: (QTextCodec*)c;
+ deleteAllCodecs;
+ (NSString *) locale;
@end

#endif
