/***************************************************************************
                            KXMLGUIClient.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLGUICLIENT_H
#define KXMLGUICLIENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 A KXMLGUIClient can be used with @ref KXMLGUIFactory to create a GUI from actions
 and an XML document, and can be dynamically merged with other KXMLGUIClients.
 
 @short 
 A KXMLGUIClient can be used with @ref KXMLGUIFactory to create a GUI from actions
 and an XML document, and can be dynamically merged with other KXMLGUIClients.
*/

@class KAction;
@class KActionCollection;
@class KInstance;
@class KXMLGUIBuilder;
@class KXMLGUIClient;
@class KXMLGUIFactory;
@class QDomDocument;
@class QDomElement;

@protocol KXMLGUIClientInterface



/** 
 Retrieves an action of the client by name.
 This method is provided for convenience, as it uses @ref  #--actionCollection
 to get the action object.
   
*/
- (KAction*) action: (NSString *)name;

/** 
 Retrieves an action for a given @ref QDomElement. The default
 implementation uses the "name" attribute to query the action
 object via the other -action method.
   
*/
- (KAction*) actionForDomElement: (QDomElement*)element;

/** 
 Retrieves the entire action collection for the GUI client
   
*/
- (KActionCollection*) actionCollection;

/** 

*/
- (KInstance*) instance;

/** 

*/
- (QDomDocument*) domDocument;

/** 
 This will return the name of the XML file as set by @ref  #--setXMLFile.
 If @ref  #--setXML is used directly, then this will return NULL.

 The filename that this returns is obvious for components as each
 component has exactly one XML file.  In non-components, however,
 there are usually two: the global file and the local file.  This
 function doesn't really care about that, though.  It will always
 return the last XML file set.  This, in almost all cases, will
 be the local XML file.

*/
- (NSString *) xmlFile;
- (NSString *) localXMLFile;

/** 

   
*/
- setXMLGUIBuildDocument: (QDomDocument*)doc;

/** 

   
*/
- (QDomDocument*) xmlguiBuildDocument;

/** 
 This method is called by the @ref KXMLGUIFactory as soon as the client
 is added to the KXMLGUIFactory's GUI.
   
*/
- setFactory: (KXMLGUIFactory*)factory;

/** 
 Retrieves a pointer to the @ref KXMLGUIFactory this client is
 associated with (will return 0L if the client's GUI has not been built
 by a KXMLGUIFactory.
   
*/
- (KXMLGUIFactory*) factory;

/** 
 KXMLGUIClients can form a simple child/parent object tree. This
 method returns a pointer to the parent client or 0L if it has no
 parent client assigned.
   
*/
- (KXMLGUIClient*) parentClient;

/** 
 Use this method to make a client a child client of another client.
 Usually you don't need to call this method, as it is called
 automatically when using the second constructor, which takes a
 arent argument.
   
*/
- insertChildClient: (KXMLGUIClient*)child;

/** 
 Removes the given @p child from the client's children list.
   
*/
- removeChildClient: (KXMLGUIClient*)child;

/** 
 A client can have an own @ref KXMLGUIBuilder.
 Use this method to assign your builder instance to the client (so that the
 @ref KXMLGUIFactory can use it when building the client's GUI)

 Client specific guibuilders are useful if you want to create
 custom container widgets for your GUI.
   
*/
- setClientBuilder: (KXMLGUIBuilder*)builder;

/** 
 Retrieves the client's GUI builder or 0L if no client specific
 builder has been assigned via @ref  #--setClientBuilder
   
*/
- (KXMLGUIBuilder*) clientBuilder;

/** 
 Forces this client to re-read its XML resource file.  This is
 intended to be used when you know that the resource file has
 changed and you will soon be rebuilding the GUI.  It has no
 useful effect with non-KParts GUIs, so don't bother using it
 unless your app is component based.
   
*/
- reloadXML;
- unplugActionList: (NSString *)name;
- addStateActionEnabled: (NSString *)state action: (NSString *)action;
- addStateActionDisabled: (NSString *)state action: (NSString *)action;
//- (StateChange) getActionsToChangeForState: (NSString *)state;
+ (NSString *) findMostRecentXMLFile: (NSArray *)files doc: (NSString *)doc;

/** 
 Sets the instance (@ref KInstance) for this part.

 Call this first in the inherited class constructor.
 (At least before @ref -setXMLFile.)
   
*/
- setInstance: (KInstance*)instance;

/** 
 Sets the name of the rc file containing the XML for the part.

 Call this in the Part-inherited class constructor.

*/
- setXMLFile: (NSString *)file merge: (BOOL)merge setXMLDoc: (BOOL)setXMLDoc;
- setXMLFile: (NSString *)file ;
- setLocalXMLFile: (NSString *)file;

/** 
 Sets the XML for the part.

 Call this in the Part-inherited class constructor if you
  don't call @ref -setXMLFile.

*/
- setXML: (NSString *)document merge: (BOOL)merge;
- setXML: (NSString *)document ;

/** 
 Sets the Document for the part, describing the layout of the GUI.

 Call this in the Part-inherited class constructor if you don't call
 @ref setXMLFile or @ref setXML .
   
*/
- setDOMDocument: (QDomDocument*)document merge: (BOOL)merge;
- setDOMDocument: (QDomDocument*)document ;

/** 
 This function will attempt to give up some memory after the GUI
 is built.  It should never be used in apps where the GUI may be
 rebuilt at some later time (components, for instance).
   
*/
- conserveMemory;
- stateChanged: (NSString *)newstate;
@end

@interface KXMLGUIClient : NSObject <QtSupport,KXMLGUIClientInterface>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
/**
 Constructs a KXMLGUIClient which can be used with a
 @ref KXMLGUIFactory to create a GUI from actions and an XML document, and
 which can be dynamically merged with other KXMLGUIClients.

*/
- init;

/**
 Constructs a KXMLGUIClient which can be used with a @ref KXMLGUIFactory
 to create a GUI from actions and an XML document,
 and which can be dynamically merged with other KXMLGUIClients.

 This constructor takes an additional @p parent argument, which makes
 the client a child client of the parent.

 Child clients are automatically added to the GUI if the parent is added.


*/
- copyWithZone: (NSZone *) zone;

/**
 Destructs the KXMLGUIClient.

*/
- (void) dealloc;

@end

#endif
