/***************************************************************************
                            KProgress.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROGRESS_H
#define KPROGRESS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QProgressBar.h>

/**

 A stylized progress bar.

 KProgress is derived from @ref QProgressBar, so
 you can use all the methods from that class. The only real difference
 is that a signal is emitted on changes to the value and you do not need
 to subclass KProgress just to change the format of the indicator text. 

 @author Aaron Seigo

 @version $Id: KProgress.h,v 1.3 2002/03/15 02:12:21 rdale Exp $
 
 @short A progress indicator widget.

*/
@interface KProgress : QProgressBar 

/** 
 Construct a progress bar.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;

/** 
 Construct a progress bar with minimum, maximum and initial values.
   
*/
- initWithInt: (int)totalSteps parent: (QWidget *)parent name: (NSString *)name f: (int)f;
- initWithInt: (int)totalSteps ;

/** 
 Destruct the progress bar.
   
*/
- (void) dealloc;

/** 
 If this is set to @p true, the progress text will be displayed.

   
*/
- setTextEnabled: (BOOL)arg1;

/** 
 @depricated Retrieves the current status, use -progress instead

*/
- (int) value;

/** 
 Returns @p true if progress text will be displayed,
 @p false otherwise.

*/
- (BOOL) textEnabled;

/** 
 Retrieve the current format for printing status text.

*/
- (NSString *) format;

/** 
 @depricated but kept for source compatibility with KDE2's KProgress.
 Use @ref -setTotalSteps instead
   
*/
- setRange: (int)min max: (int)max;

/** 
 @depricated used @ref -totalSteps instead
   
*/
- (int) maxValue;

/** 
 Set the format of the text to use to display status.

 The default format is "%p%" (which looks like "42%".)

*/
- setFormat: (NSString *)format;

/** 
 Set the current total number of steps in the action tat the progress bar
 is representing.
    
*/
- setTotalSteps: (int)totalSteps;

/** 
 @depricated. Use @ref setProgress(int) instead
    
*/
- setValue: (int)progress;

/** 
 Advance the progress bar by @p prog.

 This method is
 provided for convenience and is equivalent with
 @ref setValue(-value+prog).
   
*/
- advance: (int)offset;
@end

/** Override these methods in subclasses of KProgress to customise event handling behaviour */
@protocol KProgressEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
