/*
 * Decompiled with CFR 0.152.
 */
package netscape.constructor;

import java.io.FileInputStream;
import java.io.IOException;
import netscape.application.ExternalWindow;
import netscape.application.InternalWindow;
import netscape.application.Target;
import netscape.application.Window;
import netscape.constructor.Plan;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class PlanLoader
implements Target,
Codable {
    String url;
    boolean isRelativeURL;
    boolean asExternalWindow;
    Plan plan;
    static boolean rememberWindows;
    static Vector windowVector;
    public static final String CREATE_PLAN = "Load Plan";
    static final String HIDE_WINDOWS = "Hide Windows";
    static final String SHOW_WINDOWS = "Show Windows";
    static final String URL_KEY = "Plan URL";
    static final String IS_RELATIVE_KEY = "URL is relative to codebase";
    static final String LOAD_INTO_EXTERNAL_WINDOW = "Use External Window";

    public PlanLoader() {
        this.url = null;
        this.plan = null;
        this.isRelativeURL = false;
        this.asExternalWindow = true;
    }

    public PlanLoader(String string) {
        this(string, false);
    }

    public PlanLoader(String string, boolean bl) {
        this.url = string;
        this.plan = null;
        this.isRelativeURL = bl;
        this.asExternalWindow = true;
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public Plan plan() {
        return this.plan;
    }

    public void setPlanURL(String string) {
        this.url = string;
    }

    public String planURL() {
        return this.url;
    }

    public String fullURL() {
        return this.planURL();
    }

    public void setRelativeURL(boolean bl) {
        this.isRelativeURL = bl;
    }

    public boolean isRelativeURL() {
        return this.isRelativeURL;
    }

    public void performCommand(String string, Object object) {
        if (CREATE_PLAN.equals(string)) {
            this.createPlan();
            return;
        }
        if (HIDE_WINDOWS.equals(string)) {
            PlanLoader.hideWindows();
            return;
        }
        if (SHOW_WINDOWS.equals(string)) {
            PlanLoader.showWindows();
        }
    }

    public boolean loadInExternalWindow() {
        return this.asExternalWindow;
    }

    public void setLoadInExternalWindow(boolean bl) {
        this.asExternalWindow = bl;
    }

    public void loadPlan() {
        if (this.plan() != null) {
            this.plan.unarchiveObjects();
            return;
        }
        if (this.planURL() == null || this.planURL().length() < 1) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.fullURL());
            this.plan = new Plan();
            int n = this.plan.archiveFormatOf(this.fullURL());
            this.plan.initFrom(fileInputStream, n);
            this.plan.unarchiveObjects();
            return;
        }
        catch (IOException iOException) {
            try {
                this.plan = new Plan(this.fullURL());
                return;
            }
            catch (IOException iOException2) {
                System.err.println("PlanLoader could not load plan file: \"" + this.fullURL() + "\"");
                return;
            }
        }
    }

    public InternalWindow putPlanInInternalWindow() {
        this.loadPlan();
        if (this.plan() == null) {
            return null;
        }
        InternalWindow internalWindow = this.plan().internalWindowWithContents();
        internalWindow.setCloseable(true);
        if (PlanLoader.rememberWindows()) {
            PlanLoader.windowVector().addElement((Object)internalWindow);
        }
        return internalWindow;
    }

    public ExternalWindow putPlanInExternalWindow() {
        this.loadPlan();
        if (this.plan() == null) {
            return null;
        }
        ExternalWindow externalWindow = this.plan().externalWindowWithContents();
        if (PlanLoader.rememberWindows()) {
            PlanLoader.windowVector().addElement((Object)externalWindow);
        }
        return externalWindow;
    }

    public void createPlan() {
        if (this.asExternalWindow) {
            ExternalWindow externalWindow = this.putPlanInExternalWindow();
            if (externalWindow != null) {
                externalWindow.show();
            }
        } else {
            InternalWindow internalWindow = this.putPlanInInternalWindow();
            if (internalWindow != null) {
                internalWindow.show();
            }
        }
        if (this.plan() != null) {
            this.plan().releaseObjects();
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.constructor.PlanLoader", 1);
        classInfo.addField(URL_KEY, (byte)16);
        classInfo.addField(IS_RELATIVE_KEY, (byte)0);
        classInfo.addField(LOAD_INTO_EXTERNAL_WINDOW, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeString(URL_KEY, this.url);
        encoder.encodeBoolean(IS_RELATIVE_KEY, this.isRelativeURL);
        encoder.encodeBoolean(LOAD_INTO_EXTERNAL_WINDOW, this.asExternalWindow);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.url = decoder.decodeString(URL_KEY);
        this.isRelativeURL = decoder.decodeBoolean(IS_RELATIVE_KEY);
        this.asExternalWindow = decoder.decodeBoolean(LOAD_INTO_EXTERNAL_WINDOW);
    }

    public void finishDecoding() throws CodingException {
    }

    public static void setRememberWindows(boolean bl) {
        rememberWindows = bl;
    }

    public static boolean rememberWindows() {
        return rememberWindows;
    }

    public static Vector windowVector() {
        if (windowVector == null) {
            windowVector = new Vector();
        }
        return windowVector;
    }

    /*
     * Unable to fully structure code
     */
    public static void hideWindows() {
        var0 = PlanLoader.windowVector().count();
        if (var0 >= 1) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            if (PlanLoader.windowVector().elementAt(var0) instanceof ExternalWindow) {
                ((ExternalWindow)PlanLoader.windowVector().elementAt(var0)).dispose();
                continue;
            }
            if (!(PlanLoader.windowVector().elementAt(var0) instanceof InternalWindow)) continue;
            ((InternalWindow)PlanLoader.windowVector().elementAt(var0)).hide();
lbl9:
            // 4 sources

            ** while (--var0 >= 0)
        }
lbl10:
        // 1 sources

        PlanLoader.windowVector.removeAllElements();
    }

    /*
     * Unable to fully structure code
     */
    public static void showWindows() {
        var0 = PlanLoader.windowVector().count();
        if (var0 >= 1) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            ((Window)PlanLoader.windowVector().elementAt(var0)).show();
lbl5:
            // 2 sources

            ** while (--var0 >= 0)
        }
lbl6:
        // 1 sources

    }
}

