/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.io.IOException;
import java.io.Reader;

class SlidingBuffer
extends Reader {
    static final int DEFAULT_BUFFER_LENGTH = 4096;
    protected Reader in;
    protected char[] buffer;
    protected int offset;
    protected int end;

    public SlidingBuffer(Reader reader) {
        this.in = reader;
        this.buffer = new char[4096];
    }

    public SlidingBuffer(Reader reader, int n) {
        this.in = reader;
        if (n < 4096) {
            n = 4096;
        }
        this.buffer = new char[n];
    }

    public int read() throws IOException {
        int n = this.end - this.offset;
        if (n == 0 && !this.fill()) {
            return -1;
        }
        char c = this.buffer[this.offset++];
        return c;
    }

    public int read(char[] cArray) throws IOException {
        int n = this.end - this.offset;
        if (n == 0 && !this.fill()) {
            return -1;
        }
        n = this.end - this.offset;
        if (n > cArray.length) {
            n = cArray.length;
        }
        System.arraycopy(this.buffer, this.offset, cArray, 0, n);
        this.offset += n;
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.end - this.offset;
        if (n3 == 0 && !this.fill()) {
            return -1;
        }
        n3 = this.end - this.offset;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(this.buffer, this.offset, cArray, n, n3);
        this.offset += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        int n = this.end - this.offset;
        if ((long)n >= l) {
            this.offset = (int)((long)this.offset + l);
            return l;
        }
        this.offset = 0;
        this.end = 0;
        return (long)n + this.in.skip(l - (long)n);
    }

    public int peek() throws IOException {
        int n = this.end - this.offset;
        if (n == 0 && !this.fill()) {
            return -1;
        }
        char c = this.buffer[this.offset];
        return c;
    }

    public void unread(int n) throws IOException {
        if (this.offset < n) {
            throw new IOException("invalid unread; offset=" + this.offset + " count=" + n);
        }
        this.offset -= n;
    }

    public boolean lookAhead(char c) throws IOException {
        int n = this.end - this.offset;
        if (n == 0 && !this.fill()) {
            return false;
        }
        if (this.buffer[this.offset] == c) {
            ++this.offset;
            return true;
        }
        return false;
    }

    public boolean lookAhead(String string) throws IOException {
        return this.lookAhead(string, false);
    }

    public boolean lookAhead(String string, boolean bl) throws IOException {
        int n = this.end - this.offset;
        int n2 = string.length();
        if (n < n2 && !this.fillForCapacity(n2)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            char c = this.buffer[this.offset + n3];
            char c2 = string.charAt(n3);
            if (bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
        }
        this.offset += n2;
        return true;
    }

    public boolean eatWhiteSpace() throws IOException {
        boolean bl = false;
        do {
            int n = this.offset;
            while (n < this.end) {
                char c = this.buffer[n];
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f') {
                    this.offset = n;
                    return bl;
                }
                bl = true;
                ++n;
            }
        } while (this.fill());
        return bl;
    }

    public boolean eatNewline() throws IOException {
        boolean bl = false;
        int n = this.end - this.offset;
        if (n < 2 && !this.fillForCapacity(2)) {
            if (this.end - this.offset == 0) {
                return false;
            }
            if (this.buffer[this.offset] == '\r' || this.buffer[this.offset] == '\n') {
                ++this.offset;
                return true;
            }
            return false;
        }
        if (this.buffer[this.offset] == '\r') {
            ++this.offset;
            bl = true;
        }
        if (this.buffer[this.offset] == '\n') {
            bl = true;
            ++this.offset;
        }
        return bl;
    }

    protected boolean fill() throws IOException {
        if (this.end - this.offset != 0) {
            throw new IOException("fill of non-empty buffer");
        }
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            return false;
        }
        return true;
    }

    protected boolean fillForCapacity(int n) throws IOException {
        int n2;
        int n3 = this.end - this.offset;
        if (n3 >= n) {
            return true;
        }
        if (n >= this.buffer.length) {
            n2 = this.buffer.length * 2;
            if (n2 < n) {
                n2 = n;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.buffer, this.offset, cArray, 0, n3);
            this.offset = 0;
            this.end = n3;
            this.buffer = cArray;
        } else if (n3 != 0) {
            System.arraycopy(this.buffer, this.offset, this.buffer, 0, n3);
            this.offset = 0;
            this.end = n3;
        }
        n2 = n - n3;
        int n4 = this.in.read(this.buffer, this.offset, this.buffer.length - this.offset);
        if (n4 < n2) {
            if (n4 > 0) {
                this.end += n4;
            }
            return false;
        }
        this.end += n4;
        return true;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

