/***************************************************************************
                          kexicreateproject.h  -  description
                             -------------------
    begin                : Sun Jun 9 2002
    copyright            : (C) 2002 by lucijan busch, Joseph Wenninger
    email                : lucijan@gmx.at, jowenn@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of        *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEXICREATEPROJECT_H
#define KEXICREATEPROJECT_H

#include <kwizard.h>
#include <qpixmap.h>
#include <qptrlist.h>
#include <kexicreateprojectiface.h>
#include <qstringlist.h>
#include <klibloader.h>
//#include <kdebug.h>

/**
  *@author lucijan busch
  *@author Joseph Wenninger
  */

//class KComboBox;
//class KLineEdit;
//class KListView;
//class KTextBrowser;

class KexiProject;
class KexiCreateProjectPage;

typedef QPtrList<KexiCreateProjectPage> PageList;

/*! this class aims to represent
    the dirtiest class you ever saw
 */

class KEXIPRJWIZARD_EXPORT KexiCreateProject : public KWizard, public KexiCreateProjectIface {
   Q_OBJECT

	public:
		KexiCreateProject(QObject *project, const char *name=0, const QStringList & = QStringList());
		~KexiCreateProject();

		void registerPage(KexiCreateProjectPage *page);

		KexiProject *project()const ;
		int execute() {return exec();}
		virtual QString projectFileName();
	protected:
		void addItem(KexiCreateProjectPage *page, QString title, int index=-1);
		void requireSection(const QString &section);

		//! always the same pixmap at the left
		QPixmap *m_wpic;

		//! all the pages
		KexiCreateProjectPage	*m_pageEngine;
		KexiCreateProjectPage	*m_pageLocation;
		KexiCreateProjectPage	*m_pageAuth;
		KexiCreateProjectPage	*m_pageDatabase;
		KexiCreateProjectPage	*m_pageFile;

		PageList		m_pageList;

		QString			m_currentSection;

	private:
		KexiProject *m_project;
	protected slots:
		virtual void slotValueChanged(KexiCreateProjectPage *, QString &);
		virtual void slotPageAccepted();
		virtual void next();
		virtual void accept();
};

class KEXIPRJWIZARD_EXPORT KexiCreateProjectFactory : public KLibFactory {
        Q_OBJECT
        public:
                KexiCreateProjectFactory():KLibFactory(){}
                virtual ~KexiCreateProjectFactory(){}
                virtual QObject* createObject( QObject* parent = 0, const char* name = 0,
                const char* classname = "QObject", const QStringList &args = QStringList() )
                {
			return new KexiCreateProject(parent,name,args);
//                        kdDebug()<<"JWKEXIFACTORY"<<endl;
                }
};


#endif
