%define name      gxine
%define version	0.4.1
%define release	1

%define major   1
%define libname libxine%{major}
%define libvers 1

%define	ginstall install -c

Name:        %{name}
Summary:     GTK-based GUI for xine libraries
Summary(de): GTK basierende grafische Oberfläche für die xine-Bibliotheken
Version:     %{version}
Release:     %{release}
Copyright:   GPL
Group:       Applications/Multimedia
Source0:     %{name}-%{version}.tar.gz
URL:         http://xine.sourceforge.net/
Packager:    Manfred Tremmel <Manfred.Tremmel@iiv.de>
Requires:    %{libname} >= %{libvers}
BuildPreReq: %{libname}-devel >= %{libvers}
BuildRoot:   %{_tmppath}/%{name}-buildroot

%description
This is a GTK+ based GUI for the libxine video player library.
It provides gxine, a  media player that can play all the audio/video formats
that libxine supports. Currently, this includes MPEG1/2, some AVI and
Quicktime files, some network streaming methods and disc based media (VCD,
SVCD, DVD).
A more complete list can be found on http://xinehq.de/

Most DVDs on the market today are play-protected by the Content Scrambling
System (CSS). libxine does not provide any code to descramble those DVDs,
because of legal uncertainties. If you still want to play those DVDs, you'll
need a CSS decryption library like libdvdcss that is supported by libxine.


%description -l de
Dies ist eine GTK+ basierte GUI für die libxine Video Player Bibliothek.
Sie stellt gxine, einen Media Player zur Verfügung, welcher alle die Audio-
und Video-Formate abspielen kann, die von der libxine Bibliothek unterstützt
werden. Momentan beinhaltet dies MPEG 1/2, einige AVI und Quicktime Formate,
einige Netzwerk-Streaming-Metoden und Disk-basierende Medien (VCD, SVCD, DVD).

Eine vollständige Liste kann unter http://xinehq.de/ eingesehen werden.

Die meisten erhältlichen DVDs sind mit dem "Content Scrambling System" (CSS)
technisch geschützt. Die libxine bringt keine Funktionalität mit, diese
DVDs zu entschlüsseln, da dies in vielen Ländern illegal ist. Sollten Sie
trotzdem solche DVDs abspielen wollen, benötigen Sie eine CSS
Entschlüsselungsbibliothek wie die libdvdcss, welche von der libxine
unterstützt wird.

%prep
%setup -n %{name}-%{version}

%build
export CFLAGS="${RPM_OPT_FLAGS}"

if [ ! -f configure ]; then
   NO_CONFIGURE=1 ./autogen.sh
fi

#
# currently we do not use %%configure as it seems to cause trouble with
# certain automake produced configure scripts - depending on automake version.
#
CFLAGS="$RPM_OPT_FLAGS" ./configure --build=%{_target_platform} --prefix=%{_prefix} \
	    --exec-prefix=%{_exec_prefix} --bindir=%{_bindir} \
	    --sbindir=%{_sbindir} --sysconfdir=%{_sysconfdir} \
	    --datadir=%{_datadir} --includedir=%{_includedir} \
	    --libdir=%{_libdir} --libexecdir=%{_libexecdir} \
	    --localstatedir=%{_localstatedir} \
	    --sharedstatedir=%{_sharedstatedir} --mandir=%{_mandir} \
	    --infodir=%{_infodir}
%{__make}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
%{makeinstall}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%{_bindir}/gxin*
%{_libdir}/gxine/gxineplugin.*
%lang(de) %{_mandir}/de/man1/*
#%lang(fr) %{_mandir}/fr/man1/*
#%lang(es) %{_mandir}/es/man1/*
#%lang(pl) %{_mandir}/pl/man1/*
%{_mandir}/man1/*
%{_datadir}/applications/*
%{_datadir}/gxine/*
%{_datadir}/locale/*/LC_MESSAGES/gxine.mo

%changelog
* Thu Dec 16 2004 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- desktop file switched from %{_datadir}/gnome/ to %{_datadir}/applications/
- replaced fix delete by deleting if base dir is not root
- make use of %{makeinstall} and %{__make}
* Sun Dec 12 2004 František Dvořák <valtri@users.sourceforge.net>
- mkinstalldirs not used anymore
* Sat Nov 11 2004 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- some changes for gxine 0.4
- spec file now in UTF-8
- new description taken over from the debian package
* Sat Mar 01 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update to gxine 0.3
* Mon Dec 16 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- removed alle packman specific and added to gnome-xine cvs
* Sat Dec 07 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update to gxine 0.2
* Thu Dec 05 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- initial release
